/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.publications_retriever.util.file;

import eu.openaire.publications_retriever.exceptions.FileNotRetrievedException;
import eu.openaire.publications_retriever.util.args.ArgsUtils;
import eu.openaire.publications_retriever.util.file.FileData;
import eu.openaire.publications_retriever.util.file.FileUtils;
import eu.openaire.publications_retriever.util.url.UrlUtils;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlFileUtils {
    private static final Logger logger = LoggerFactory.getLogger(HtmlFileUtils.class);
    public static final AtomicInteger htmlFilesNum = new AtomicInteger(0);
    public static final HashMap<String, Integer> numbersOfDuplicateHtmlFileNames = new HashMap();

    public static FileData getFinalHtmlFilePath(String urlId, String pageUrl, Matcher urlMatcher, int contentSize) throws FileNotRetrievedException {
        String fileName = urlId;
        if (ArgsUtils.fileNameType.equals((Object)ArgsUtils.fileNameTypeEnum.originalName)) {
            fileName = UrlUtils.getDocIdStr(pageUrl, urlMatcher);
            if (fileName == null) {
                fileName = urlId;
            }
        } else if (ArgsUtils.fileNameType.equals((Object)ArgsUtils.fileNameTypeEnum.numberName)) {
            fileName = String.valueOf(htmlFilesNum.incrementAndGet());
        }
        return FileUtils.getFileAndHandleExisting(fileName, ".html", false, contentSize, ArgsUtils.storeHtmlFilesDir, numbersOfDuplicateHtmlFileNames);
    }
}

