/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps;

import crawlercommons.sitemaps.AbstractSiteMap;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class SiteMapIndex
extends AbstractSiteMap {
    private List<AbstractSiteMap> sitemaps = new ArrayList<AbstractSiteMap>();

    public SiteMapIndex() {
    }

    public SiteMapIndex(URL url) {
        this();
        this.url = url;
    }

    public Collection<AbstractSiteMap> getSitemaps() {
        return this.sitemaps;
    }

    public Collection<AbstractSiteMap> getSitemaps(boolean deduplicate) {
        if (deduplicate) {
            HashSet urls2 = new HashSet(this.sitemaps.size());
            return this.sitemaps.stream().filter(s -> urls2.add(s.url.toString())).collect(Collectors.toList());
        }
        return this.sitemaps;
    }

    public void addSitemap(AbstractSiteMap sitemap) {
        this.sitemaps.add(sitemap);
    }

    public AbstractSiteMap getSitemap(URL url) {
        if (url == null) {
            return null;
        }
        String u = url.toString();
        for (AbstractSiteMap asm : this.sitemaps) {
            URL su = asm.getUrl();
            if (su == null || !su.toString().equals(u)) continue;
            return asm;
        }
        return null;
    }

    public boolean hasUnprocessedSitemap() {
        return this.nextUnprocessedSitemap() != null;
    }

    public AbstractSiteMap nextUnprocessedSitemap() {
        for (AbstractSiteMap asm : this.sitemaps) {
            if (asm.isProcessed()) continue;
            return asm;
        }
        return null;
    }

    @Override
    public boolean isIndex() {
        return true;
    }

    public String toString() {
        return "url = \"" + String.valueOf(this.url) + "\", sitemapListSize = " + this.sitemaps.size();
    }
}

