/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.publications_retriever.util.file;

import eu.openaire.publications_retriever.util.file.FileData;
import eu.openaire.publications_retriever.util.file.FileUtils;
import io.minio.BucketExistsArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.UploadObjectArgs;
import io.minio.messages.Item;
import java.io.File;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ObjectStore {
    private static final Logger logger = LoggerFactory.getLogger(S3ObjectStore.class);
    private static String endpoint = null;
    private static String accessKey = null;
    private static String secretKey = null;
    private static String region = null;
    private static String bucketName = null;
    private static MinioClient minioClient;
    public static final boolean shouldEmptyBucket = false;
    public static final String credentialsFilePath;
    private static final boolean shouldShowAllS3Buckets = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3ObjectStore() {
        String errorMsg;
        try (Scanner myReader = null;){
            File credentialsFile = new File(credentialsFilePath);
            if (!credentialsFile.exists()) {
                throw new RuntimeException("credentialsFile \"" + credentialsFilePath + "\" does not exists!");
            }
            myReader = new Scanner(credentialsFile);
            if (myReader.hasNextLine()) {
                String[] credentials = myReader.nextLine().split(",");
                if (credentials.length < 5) {
                    throw new RuntimeException("Not all credentials were retrieved from file \"" + credentialsFilePath + "\"!");
                }
                endpoint = credentials[0].trim();
                accessKey = credentials[1].trim();
                secretKey = credentials[2].trim();
                region = credentials[3].trim();
                bucketName = credentials[4].trim();
            }
        }
        if (endpoint == null || accessKey == null || secretKey == null || region == null || bucketName == null) {
            String errorMsg2 = "No \"endpoint\" or/and \"accessKey\" or/and \"secretKey\" or/and \"region\" or/and \"bucketName\" could be retrieved from the file: " + credentialsFilePath;
            logger.error(errorMsg2);
            System.err.println(errorMsg2);
            System.exit(54);
        }
        minioClient = MinioClient.builder().endpoint(endpoint).credentials(accessKey, secretKey).region(region).build();
        minioClient.setTimeout(TimeUnit.MINUTES.toMillis(1L), TimeUnit.MINUTES.toMillis(5L), TimeUnit.MINUTES.toMillis(5L));
        boolean bucketExists = false;
        try {
            bucketExists = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            errorMsg = "There was a problem while checking if the bucket \"" + bucketName + "\" exists!\n" + e.getMessage();
            logger.error(errorMsg);
            System.err.println(errorMsg);
            System.exit(55);
        }
        try {
            if (!bucketExists) {
                logger.info("Bucket \"" + bucketName + "\" does not exist! Going to create it..");
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
            } else {
                logger.debug("Bucket \"" + bucketName + "\" already exists.");
            }
        }
        catch (Exception e) {
            errorMsg = "Could not create the bucket \"" + bucketName + "\"!";
            logger.error(errorMsg, e);
            System.err.println(errorMsg);
            System.exit(56);
        }
    }

    public static FileData uploadToS3(String fileObjKeyName, String fileFullPath) {
        String contentType = null;
        Matcher extensionMatcher = FileUtils.EXTENSION_PATTERN.matcher(fileFullPath);
        if (extensionMatcher.find()) {
            String extension = null;
            extension = extensionMatcher.group(0);
            contentType = extension == null ? "application/pdf" : (extension.equals("pdf") ? "application/pdf" : "application/pdf");
        } else {
            logger.warn("The file with key \"" + fileObjKeyName + "\" does not have a file-extension! Setting the \"pdf\"-mimeType.");
            contentType = "application/pdf";
        }
        try {
            ObjectWriteResponse response = minioClient.uploadObject((UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(bucketName)).object(fileObjKeyName)).filename(fileFullPath).contentType(contentType).build());
        }
        catch (Exception e) {
            logger.error("Could not upload the file \"" + fileObjKeyName + "\" to the S3 ObjectStore, exception: " + e.getMessage(), e);
            return null;
        }
        String s3Url = endpoint + "/" + bucketName + "/" + fileObjKeyName;
        logger.debug("Uploaded file \"" + fileObjKeyName + "\". The s3Url is: " + s3Url);
        return new FileData(null, null, 0L, s3Url);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean emptyBucket(String bucketName, boolean shouldDeleteBucket) {
        Iterable<Result<Item>> results;
        logger.warn("Going to " + (shouldDeleteBucket ? "delete" : "empty") + " bucket \"" + bucketName + "\"!");
        try {
            results = minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            logger.error("Could not retrieve the list of objects of bucket \"" + bucketName + "\"!");
            return false;
        }
        int countDeletedFiles = 0;
        int countFilesNotDeleted = 0;
        long totalSize = 0L;
        for (Result<Item> resultItem : results) {
            Item item;
            try {
                item = resultItem.get();
            }
            catch (Exception e) {
                logger.error("Could not get the item-object of one of the S3-Objects returned from the bucket!", e);
                ++countFilesNotDeleted;
                continue;
            }
            totalSize += item.size();
            if (!S3ObjectStore.deleteFile(item.objectName(), bucketName)) {
                logger.error("Cannot proceed with bucket deletion, since only an empty bucket can be removed!");
                ++countFilesNotDeleted;
                continue;
            }
            ++countDeletedFiles;
        }
        if (shouldDeleteBucket) {
            if (countFilesNotDeleted != 0) {
                logger.error("Cannot execute the \"removeBucket\" command for bucket \"" + bucketName + "\", as " + countFilesNotDeleted + " files failed to be deleted!");
                return false;
            }
            try {
                minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
                logger.info("Bucket \"" + bucketName + "\" was deleted!");
            }
            catch (Exception e) {
                logger.error("Bucket \"" + bucketName + "\" could not be deleted!", e);
                return false;
            }
        } else {
            logger.info("Bucket \"" + bucketName + "\" was emptied!");
        }
        logger.info(countDeletedFiles + " files were deleted, amounting to " + totalSize / 1024L / 1024L + " MB.");
        return true;
    }

    public static boolean deleteFile(String fileObjKeyName, String bucketName) {
        try {
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(fileObjKeyName)).build());
        }
        catch (Exception e) {
            logger.error("Could not delete the file \"" + fileObjKeyName + "\" from the S3 ObjectStore, exception: " + e.getMessage(), e);
            return false;
        }
        return true;
    }

    static {
        credentialsFilePath = FileUtils.workingDir + "S3_credentials.txt";
    }
}

