/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.ObjectArgs;
import java.util.Map;
import java.util.Objects;

public class PromptObjectArgs
extends ObjectArgs {
    private String prompt;
    private String lambdaArn;
    private Map<String, Object> promptArgs;
    private Map<String, String> headers;

    public String prompt() {
        return this.prompt;
    }

    public String lambdaArn() {
        return this.lambdaArn;
    }

    public Map<String, Object> promptArgs() {
        return this.promptArgs;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PromptObjectArgs)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PromptObjectArgs that = (PromptObjectArgs)o;
        return Objects.equals(this.prompt, that.prompt) && Objects.equals(this.lambdaArn, that.lambdaArn) && Objects.equals(this.promptArgs, that.promptArgs) && Objects.equals(this.headers, that.headers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.prompt, this.lambdaArn, this.promptArgs, this.headers);
    }

    public static final class Builder
    extends ObjectArgs.Builder<Builder, PromptObjectArgs> {
        @Override
        protected void validate(PromptObjectArgs args2) {
            super.validate(args2);
            this.validateNotEmptyString(args2.prompt, "prompt");
            this.validateNotEmptyString(args2.lambdaArn, "lambda ARN");
            this.validateNotNull(args2.promptArgs, "prompt argument");
        }

        public Builder offset(String prompt) {
            this.validateNotEmptyString(prompt, "prompt");
            this.operations.add(args2 -> ((PromptObjectArgs)args2).prompt = prompt);
            return this;
        }

        public Builder lambdaArn(String lambdaArn) {
            this.validateNotEmptyString(lambdaArn, "lambda ARN");
            this.operations.add(args2 -> ((PromptObjectArgs)args2).lambdaArn = lambdaArn);
            return this;
        }

        public Builder promptArgs(Map<String, Object> promptArgs) {
            this.validateNotNull(promptArgs, "prompt argument");
            this.operations.add(args2 -> ((PromptObjectArgs)args2).promptArgs = promptArgs);
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.operations.add(args2 -> ((PromptObjectArgs)args2).headers = headers);
            return this;
        }
    }
}

