/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.BaseArgs;
import java.util.Objects;

public class ListBucketsArgs
extends BaseArgs {
    private String bucketRegion;
    private int maxBuckets = 10000;
    private String prefix;
    private String continuationToken;

    public String bucketRegion() {
        return this.bucketRegion;
    }

    public int maxBuckets() {
        return this.maxBuckets;
    }

    public String prefix() {
        return this.prefix;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListBucketsArgs)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListBucketsArgs that = (ListBucketsArgs)o;
        return Objects.equals(this.bucketRegion, that.bucketRegion) && this.maxBuckets == that.maxBuckets && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.continuationToken, that.continuationToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bucketRegion, this.maxBuckets, this.prefix, this.continuationToken);
    }

    public static final class Builder
    extends BaseArgs.Builder<Builder, ListBucketsArgs> {
        @Override
        protected void validate(ListBucketsArgs args2) {
        }

        public Builder bucketRegion(String region) {
            this.validateNullOrNotEmptyString(region, "bucket region");
            this.operations.add(args2 -> ((ListBucketsArgs)args2).bucketRegion = region);
            return this;
        }

        public Builder maxBuckets(int maxBuckets) {
            if (maxBuckets < 1 || maxBuckets > 10000) {
                throw new IllegalArgumentException("max buckets must be between 1 and 10000");
            }
            this.operations.add(args2 -> ((ListBucketsArgs)args2).maxBuckets = maxBuckets);
            return this;
        }

        public Builder prefix(String prefix) {
            this.validateNullOrNotEmptyString(prefix, "prefix");
            this.operations.add(args2 -> ((ListBucketsArgs)args2).prefix = prefix);
            return this;
        }

        public Builder continuationToken(String continuationToken) {
            this.validateNullOrNotEmptyString(continuationToken, "continuation token");
            this.operations.add(args2 -> ((ListBucketsArgs)args2).continuationToken = continuationToken);
            return this;
        }
    }
}

