/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.publications_retriever.util.url;

import eu.openaire.publications_retriever.crawler.PageCrawler;
import eu.openaire.publications_retriever.util.file.FileUtils;
import eu.openaire.publications_retriever.util.http.ConnSupportUtils;
import eu.openaire.publications_retriever.util.http.HttpConnUtils;
import eu.openaire.publications_retriever.util.url.UrlUtils;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericUtils {
    private static final Logger logger = LoggerFactory.getLogger(GenericUtils.class);

    public static boolean checkInternetConnectivity() {
        try {
            new URL("https://www.google.com/").openConnection().connect();
            logger.info("The internet connection is successful.");
            return true;
        }
        catch (Exception e) {
            logger.error("The internet connection has failed!", e);
            return false;
        }
    }

    public static void clearBlockingData() {
        HttpConnUtils.blacklistedDomains.clear();
        HttpConnUtils.timesDomainsHadInputNotBeingDocNorPage.clear();
        HttpConnUtils.timesDomainsReturnedNoType.clear();
        ConnSupportUtils.timesDomainsReturned5XX.clear();
        ConnSupportUtils.timesDomainsHadTimeoutEx.clear();
        PageCrawler.timesDomainNotGivingInternalLinks.clear();
        PageCrawler.timesDomainNotGivingDocUrls.clear();
        UrlUtils.domainsAndNumHits.clear();
        ConnSupportUtils.timesPathsReturned403.clear();
        ConnSupportUtils.domainsMultimapWithPaths403BlackListed.clear();
        PageCrawler.should_check_remaining_links = true;
        PageCrawler.timesCheckedRemainingLinks.set(0);
        PageCrawler.timesFoundDocOrDatasetUrlFromRemainingLinks.set(0);
    }

    public static void clearTrackingData() {
        GenericUtils.clearBlockingData();
        UrlUtils.resultUrlsWithIDs.clear();
        ConnSupportUtils.fileHashesWithLocations.clear();
        HttpConnUtils.domainsSupportingHTTPS.clear();
        HttpConnUtils.domainsWithSlashRedirect.clear();
        HttpConnUtils.domainsWithUnsupportedHeadMethod.clear();
        HttpConnUtils.domainsWithUnsupportedAcceptLanguageParameter.clear();
        ConnSupportUtils.domainsWithConnectionData.clear();
    }

    public static String getSelectedStackTraceForCausedException(Throwable thr, String firstMessage, String additionalMessage, int numOfLines) {
        Throwable causedThrowable = thr.getCause();
        if (causedThrowable == null) {
            logger.warn("No cause was retrieved for the \"ExecutionException\"!");
            causedThrowable = thr;
        }
        String initialMessage = firstMessage + causedThrowable.getMessage() + (additionalMessage != null ? additionalMessage : "");
        return GenericUtils.getSelectiveStackTrace(causedThrowable, initialMessage, numOfLines);
    }

    public static String getSelectiveStackTrace(Throwable thr, String initialMessage, int numOfLines) {
        StackTraceElement[] stels = thr.getStackTrace();
        StringBuilder sb = new StringBuilder(numOfLines * 100);
        if (initialMessage != null) {
            sb.append(initialMessage).append(FileUtils.endOfLine);
        }
        sb.append("Stacktrace:").append(FileUtils.endOfLine);
        for (int i = 0; i < stels.length && i <= numOfLines; ++i) {
            sb.append(stels[i]);
            if (i >= numOfLines) continue;
            sb.append(FileUtils.endOfLine);
        }
        return sb.toString();
    }
}

