/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax;

import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.SiteMap;
import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.SiteMapURL;
import crawlercommons.sitemaps.extension.Extension;
import crawlercommons.sitemaps.sax.DelegatorHandler;
import crawlercommons.sitemaps.sax.extension.ExtensionHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLHandler
extends DelegatorHandler {
    private SiteMap sitemap;
    private String loc;
    private String lastMod;
    private String changeFreq;
    private String priority;
    private int i = 0;
    private boolean currentElementNamespaceIsValid;
    private String currentElementNamespace;
    protected Map<Extension, ExtensionHandler> extensionHandlers;

    XMLHandler(URL url, LinkedList<String> elementStack, boolean strict) {
        super(elementStack, strict);
        this.sitemap = new SiteMap(url);
        this.sitemap.setType(AbstractSiteMap.SitemapType.XML);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentElementNamespace = uri;
        if (this.isExtensionNamespace(uri)) {
            ExtensionHandler eh = this.getExtensionHandler(uri);
            eh.startElement(uri, localName, qName, attributes);
            return;
        }
        if (this.isStrictNamespace() && !this.isAcceptedNamespace(uri)) {
            SiteMapParser.LOG.debug("Skip element <{}>, namespace <{}> not accepted", (Object)localName, (Object)uri);
            this.currentElementNamespaceIsValid = false;
            return;
        }
        this.currentElementNamespaceIsValid = true;
        if ("loc".equals(localName) || "url".equals(localName)) {
            if (this.loc == null) {
                this.loc = this.getAndResetCharacterBuffer();
            }
            if (this.loc != null && !XMLHandler.isAllBlank(this.loc)) {
                this.maybeAddSiteMapUrl();
                return;
            }
            this.loc = null;
            if ("url".equals(localName)) {
                this.lastMod = null;
                this.changeFreq = null;
                this.priority = null;
            }
        }
        this.resetCharacterBuffer();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.isExtensionNamespace(uri)) {
            ExtensionHandler eh = this.getExtensionHandler(uri);
            eh.endElement(uri, localName, qName);
            return;
        }
        if (this.isStrictNamespace() && !this.isAcceptedNamespace(uri)) {
            return;
        }
        if ("url".equals(localName)) {
            if ("urlset".equals(this.currentElementParent())) {
                this.maybeAddSiteMapUrl();
            }
        } else if ("urlset".equals(localName)) {
            this.sitemap.setProcessed(true);
        } else if ("loc".equals(localName)) {
            this.loc = this.getAndResetCharacterBuffer();
        } else if ("changefreq".equals(localName)) {
            this.changeFreq = this.getAndResetCharacterBuffer();
        } else if ("lastmod".equals(localName)) {
            this.lastMod = this.getAndResetCharacterBuffer();
        } else if ("priority".equals(localName)) {
            this.priority = this.getAndResetCharacterBuffer();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isExtensionNamespace(this.currentElementNamespace)) {
            ExtensionHandler eh = this.getExtensionHandler(this.currentElementNamespace);
            eh.characters(ch, start, length);
            return;
        }
        if (this.isStrictNamespace() && !this.currentElementNamespaceIsValid) {
            return;
        }
        String localName = this.currentElement();
        if ("loc".equals(localName) || "url".equals(localName) || "changefreq".equals(localName) || "lastmod".equals(localName) || "priority".equals(localName)) {
            this.appendCharacterBuffer(ch, start, length);
        }
    }

    @Override
    public AbstractSiteMap getSiteMap() {
        return this.sitemap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddSiteMapUrl() {
        String value = null;
        if (this.loc != null) {
            value = XMLHandler.stripAllBlank(this.loc);
        } else if ("loc".equals(this.currentElement())) {
            value = this.getAndResetCharacterBuffer();
        }
        if (value == null || XMLHandler.isAllBlank(value)) {
            return;
        }
        String urlFiltered = (String)this.urlFilter.apply(value);
        if (urlFiltered == null) {
            SiteMapParser.LOG.debug("Filtered URL {}", (Object)value);
            return;
        }
        try {
            URL locURL = new URL(urlFiltered);
            boolean valid = SiteMapParser.urlIsValid(this.sitemap.getBaseUrl(), locURL.toString());
            if (valid || !this.isStrict()) {
                SiteMapURL sUrl = new SiteMapURL(locURL, valid);
                sUrl.setLastModified(this.lastMod);
                sUrl.setChangeFrequency(this.changeFreq);
                sUrl.setPriority(this.priority);
                this.sitemap.addSiteMapUrl(sUrl);
                SiteMapParser.LOG.debug("  {}. {}", (Object)(++this.i), (Object)sUrl);
                if (this.extensionHandlers != null) {
                    for (Map.Entry<Extension, ExtensionHandler> e : this.extensionHandlers.entrySet()) {
                        sUrl.addAttributesForExtension(e.getKey(), e.getValue().getAttributes());
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            SiteMapParser.LOG.debug("Bad url: [{}]", (Object)value);
            SiteMapParser.LOG.trace("Can't create an entry with a bad URL", e);
        }
        finally {
            this.loc = null;
            this.lastMod = null;
            this.changeFreq = null;
            this.priority = null;
            this.resetExtensionHandlers();
        }
    }

    protected ExtensionHandler getExtensionHandler(String uri) {
        if (this.extensionNamespaces.containsKey(uri)) {
            Extension ext = (Extension)((Object)this.extensionNamespaces.get(uri));
            if (this.extensionHandlers == null) {
                this.extensionHandlers = new TreeMap<Extension, ExtensionHandler>();
            }
            if (!this.extensionHandlers.containsKey((Object)ext)) {
                this.extensionHandlers.put(ext, ExtensionHandler.create(ext));
            }
            return this.extensionHandlers.get((Object)ext);
        }
        return null;
    }

    protected Collection<ExtensionHandler> getExtensionHandlers() {
        if (this.extensionHandlers == null) {
            return new ArrayList<ExtensionHandler>();
        }
        return this.extensionHandlers.values();
    }

    public void resetExtensionHandlers() {
        if (this.extensionHandlers != null) {
            for (Map.Entry<Extension, ExtensionHandler> e : this.extensionHandlers.entrySet()) {
                e.getValue().reset();
            }
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.maybeAddSiteMapUrl();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.maybeAddSiteMapUrl();
    }
}

