/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.extension;

import crawlercommons.sitemaps.extension.ExtensionMetadata;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ImageAttributes
extends ExtensionMetadata {
    public static final String LOC = "loc";
    public static final String CAPTION = "caption";
    public static final String GEO_LOCATION = "geo_location";
    public static final String TITLE = "title";
    public static final String LICENSE = "license";
    private URL loc;
    private String caption;
    private String geoLocation;
    private String title;
    private URL license;

    public URL getLoc() {
        return this.loc;
    }

    public void setLoc(URL loc) {
        this.loc = loc;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getGeoLocation() {
        return this.geoLocation;
    }

    public void setGeoLocation(String geoLocation) {
        this.geoLocation = geoLocation;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public URL getLicense() {
        return this.license;
    }

    public void setLicense(URL license) {
        this.license = license;
    }

    public ImageAttributes() {
    }

    public ImageAttributes(URL loc) {
        this.loc = loc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Image loc: ").append(this.loc);
        sb.append(", caption: ").append(this.caption);
        sb.append(", title: ").append(this.title);
        sb.append(", geoLocation: ").append(this.geoLocation);
        sb.append(", license: ").append(this.license);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        return this.loc != null;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ImageAttributes)) {
            return false;
        }
        ImageAttributes that = (ImageAttributes)other;
        return ImageAttributes.urlEquals(this.loc, that.loc) && Objects.equals(this.caption, that.caption) && Objects.equals(this.geoLocation, that.geoLocation) && Objects.equals(this.title, that.title) && ImageAttributes.urlEquals(this.license, that.license);
    }

    @Override
    public Map<String, String[]> asMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (this.loc != null) {
            map.put(LOC, new String[]{this.loc.toString()});
        }
        if (this.caption != null) {
            map.put(CAPTION, new String[]{this.caption});
        }
        if (this.geoLocation != null) {
            map.put(GEO_LOCATION, new String[]{this.geoLocation});
        }
        if (this.title != null) {
            map.put(TITLE, new String[]{this.title});
        }
        if (this.license != null) {
            map.put(LICENSE, new String[]{this.license.toString()});
        }
        return Collections.unmodifiableMap(map);
    }
}

