/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.GenericResponse;
import io.minio.messages.CompleteMultipartUploadOutput;
import io.minio.messages.CopyObjectResult;
import okhttp3.Headers;

public class ObjectWriteResponse
extends GenericResponse {
    private String etag;
    private String versionId;
    private String checksumCRC32;
    private String checksumCRC32C;
    private String checksumSHA1;
    private String checksumSHA256;

    public ObjectWriteResponse(Headers headers, String bucket, String region, String object, String etag, String versionId) {
        super(headers, bucket, region, object);
        this.etag = etag;
        this.versionId = versionId;
        if (headers != null) {
            this.checksumCRC32 = headers.get("x-amz-checksum-crc32");
            this.checksumCRC32C = headers.get("x-amz-checksum-crc32c");
            this.checksumSHA1 = headers.get("x-amz-checksum-sha1");
            this.checksumSHA256 = headers.get("x-amz-checksum-sha256");
        }
    }

    public ObjectWriteResponse(Headers headers, String bucket, String region, String object, String etag, String versionId, CopyObjectResult result) {
        super(headers, bucket, region, object);
        this.etag = etag;
        this.versionId = versionId;
        if (result != null) {
            this.checksumCRC32 = result.checksumCRC32();
            this.checksumCRC32C = result.checksumCRC32C();
            this.checksumSHA1 = result.checksumSHA1();
            this.checksumSHA256 = result.checksumSHA256();
        }
    }

    public ObjectWriteResponse(Headers headers, String bucket, String region, String object, String etag, String versionId, CompleteMultipartUploadOutput result) {
        super(headers, bucket, region, object);
        this.etag = etag;
        this.versionId = versionId;
        if (result != null) {
            this.checksumCRC32 = result.checksumCRC32();
            this.checksumCRC32C = result.checksumCRC32C();
            this.checksumSHA1 = result.checksumSHA1();
            this.checksumSHA256 = result.checksumSHA256();
        }
    }

    public String etag() {
        return this.etag;
    }

    public String versionId() {
        return this.versionId;
    }

    public String checksumCRC32() {
        return this.checksumCRC32;
    }

    public String checksumCRC32C() {
        return this.checksumCRC32C;
    }

    public String checksumSHA1() {
        return this.checksumSHA1;
    }

    public String checksumSHA256() {
        return this.checksumSHA256;
    }
}

