/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.task;

import eu.dnetlib.validator2.result_models.ValidationProblem;

public final class RuleEvaluationResult {
    private static final byte SUCCESS = 0;
    private static final byte FAILURE = 2;
    private static final byte ERROR = 4;
    private static final byte INTERRUPTED = 8;
    private final byte result;
    private final ValidationProblem problem;

    RuleEvaluationResult(byte result, ValidationProblem problem) {
        this.result = result;
        this.problem = problem;
    }

    public boolean succeeded() {
        return this.result == 0;
    }

    public boolean failed() {
        return this.result == 2;
    }

    public boolean errored() {
        return this.result == 4;
    }

    public boolean interrupted() {
        return this.result == 8;
    }

    public ValidationProblem getProblem() {
        return this.problem;
    }

    static RuleEvaluationResult forSuccess() {
        return new RuleEvaluationResult(0, null);
    }

    static RuleEvaluationResult forFailure(String message, String suggestion) {
        return new RuleEvaluationResult(2, new ValidationProblem(message, suggestion));
    }

    static RuleEvaluationResult forError(String errorMessage) {
        return new RuleEvaluationResult(4, new ValidationProblem(errorMessage, null));
    }

    static RuleEvaluationResult forInterrupted() {
        return new RuleEvaluationResult(8, null);
    }
}

