/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.engine.execution;

import eu.dnetlib.validator.engine.data.Rule;
import eu.dnetlib.validator.engine.data.RuleException;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import java.util.List;
import org.apache.log4j.Logger;

public class Task
implements Runnable {
    public final ValidationObject valobj;
    public final Rule rule;
    private boolean success;
    private List<String> errors;
    private Exception exception = null;

    public Task(ValidationObject valobj, Rule rule) {
        this.valobj = valobj;
        this.rule = rule;
    }

    @Override
    public void run() {
        Logger log = Logger.getLogger(Task.class);
        try {
            this.success = this.rule.apply(this.valobj);
            this.setErrors(this.rule.getErrors());
        }
        catch (RuleException e) {
            log.error((Object)"Error applyling rule on task", (Throwable)e);
            this.exception = e;
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Exception getException() {
        return this.exception;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }
}

