/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.service.controllers;

import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.repo.manager.shared.Aggregations;
import eu.dnetlib.repo.manager.shared.Country;
import eu.dnetlib.repo.manager.shared.MetricsInfo;
import eu.dnetlib.repo.manager.shared.RepositoryServiceException;
import eu.dnetlib.repo.manager.shared.Timezone;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/repository"})
@Api(description="Repository API", tags={"repository"})
public interface RepositoryApi {
    @RequestMapping(value={"/testAggregations"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> testAggregations() throws JSONException;

    @RequestMapping(value={"/getCountries"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Country[] getCountries();

    @RequestMapping(value={"/getRepositoriesByCountry/{country}/{mode}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Repository> getRepositoriesByCountry(String var1, String var2, Boolean var3) throws JSONException;

    @RequestMapping(value={"/getRepositoriesOfUser/{userEmail}/{page}/{size}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Repository> getRepositoriesOfUser(String var1, String var2, String var3) throws JSONException;

    @RequestMapping(value={"/getRepositoryById/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Repository getRepositoryById(String var1) throws JSONException;

    @RequestMapping(value={"/getRepositoryAggregations/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Aggregations getRepositoryAggregations(String var1) throws JSONException;

    @RequestMapping(value={"/getRepositoriesByName/{name}/{page}/{size}/"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Repository> getRepositoriesByName(String var1, String var2, String var3) throws JSONException;

    @RequestMapping(value={"/getRepositoryInterface/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<RepositoryInterface> getRepositoryInterface(String var1) throws JSONException;

    @RequestMapping(value={"/addRepository"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public void addRepository(String var1, Repository var2) throws Exception;

    @RequestMapping(value={"/deleteInterface"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteRepositoryInterface(String var1);

    @RequestMapping(value={"/addInterface"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public RepositoryInterface addRepositoryInterface(String var1, String var2, RepositoryInterface var3) throws JSONException;

    @RequestMapping(value={"/getDnetCountries"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getDnetCountries();

    @RequestMapping(value={"/getTypologies"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getTypologies();

    @RequestMapping(value={"/getTimezones"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Timezone> getTimezones();

    @RequestMapping(value={"/updateManagedStatus"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public String updateManagedStatus(String var1, String var2);

    @RequestMapping(value={"/updateEnglishName"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public String updateEnglishName(String var1, String var2);

    @RequestMapping(value={"/updateLatitude"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public String updateLatitude(String var1, String var2);

    @RequestMapping(value={"/updateLongitude"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public String updateLongitude(String var1, String var2);

    @RequestMapping(value={"/updateOfficialName"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public String updateOfficialName(String var1, String var2);

    @RequestMapping(value={"/updateTimezone"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public String updateTimezone(String var1, String var2);

    @RequestMapping(value={"/updateTypology"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public String updateTypology(String var1, String var2);

    @RequestMapping(value={"/updateLogoUrl"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public String updateLogoUrl(String var1, String var2);

    @RequestMapping(value={"/updatePlatform"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public String updatePlatform(String var1, String var2);

    @RequestMapping(value={"/getUrlsOfUserRepos/{user_email}/{page}/{size}/"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getUrlsOfUserRepos(String var1, String var2, String var3) throws JSONException;

    @RequestMapping(value={"/getDatasourceVocabularies/{mode}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getDatasourceVocabularies(String var1);

    @RequestMapping(value={"/getCompatibilityClasses/{mode}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, String> getCompatibilityClasses(String var1);

    @RequestMapping(value={"/getDatasourceClasses/{mode}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, String> getDatasourceClasses(String var1);

    public String getCountryName(String var1);

    @RequestMapping(value={"/getMetricsInfoForRepository/{repoId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public MetricsInfo getMetricsInfoForRepository(String var1) throws RepositoryServiceException;
}

