/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.service.controllers;

import eu.dnetlib.domain.data.PiwikInfo;
import eu.dnetlib.repo.manager.service.controllers.PiWikApi;
import eu.dnetlib.utils.md5.MD5;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;

@Component
public class PiWikApiImpl
implements PiWikApi {
    @Autowired
    @Qualifier(value="repomanager.dataSource")
    private DataSource dataSource;
    private static final Logger LOGGER = Logger.getLogger(PiWikApiImpl.class);
    private static final String GET_PIWIK_SITE = "select repositoryid, siteid, authenticationtoken, creationdate, requestorname, requestoremail, validated, validationdate, comment, repositoryname, country from piwik_site where repositoryid = ?;";
    private static final String INSERT_PIWIK_INFO = "insert into piwik_site (repositoryid, siteid, creationdate, requestorname, requestoremail, validated, repositoryname, country, authenticationtoken) values (?, ?, now(), ?, ?, ?, ?, ?, ?)";
    private static final String GET_PIWIK_SITES = "select repositoryid, siteid, authenticationtoken, creationdate, requestorname, requestoremail, validated, validationdate, comment, repositoryname, country from piwik_site order by repositoryname";
    private static final String APPROVE_PIWIK_SITE = "update piwik_site set validated=true, validationdate=now() where repositoryid = ?;";
    private RowMapper<PiwikInfo> piwikRowMapper = (rs, i) -> new PiwikInfo(rs.getString("repositoryid"), this.getOpenaireId(rs.getString("repositoryid")), rs.getString("repositoryname"), rs.getString("country"), rs.getString("siteid"), rs.getString("authenticationtoken"), (Date)rs.getTimestamp("creationdate"), rs.getString("requestorname"), rs.getString("requestoremail"), rs.getBoolean("validated"), (Date)rs.getTimestamp("validationdate"), rs.getString("comment"));

    @Override
    public PiwikInfo getPiwikSiteForRepo(@PathVariable(value="repositoryId") String repositoryId) {
        try {
            return (PiwikInfo)new JdbcTemplate(this.dataSource).queryForObject(GET_PIWIK_SITE, (Object[])new String[]{repositoryId}, new int[]{12}, this.piwikRowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public PiwikInfo savePiwikInfo(PiwikInfo piwikInfo) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update(INSERT_PIWIK_INFO, new Object[]{piwikInfo.getRepositoryId(), piwikInfo.getSiteId(), piwikInfo.getRequestorName(), piwikInfo.getRequestorEmail(), piwikInfo.isValidated(), piwikInfo.getRepositoryName(), piwikInfo.getCountry(), piwikInfo.getAuthenticationToken()}, new int[]{12, 12, 12, 12, 16, 12, 12, 12});
        return piwikInfo;
    }

    @Override
    public List<PiwikInfo> getPiwikSitesForRepos() {
        LOGGER.debug((Object)"Getting piwik sites for repos! ");
        try {
            return new JdbcTemplate(this.dataSource).query(GET_PIWIK_SITES, this.piwikRowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public void approvePiwikSite(@PathVariable(value="repositoryId") String repositoryId) {
        new JdbcTemplate(this.dataSource).update(APPROVE_PIWIK_SITE, new Object[]{repositoryId}, new int[]{12});
    }

    @Override
    public String getOpenaireId(@PathVariable(value="repositoryId") String repositoryid) {
        try {
            if (repositoryid != null && repositoryid.contains("::")) {
                return repositoryid.split("::")[0] + "::" + MD5.encrypt2Hex((String)repositoryid.split("::")[1]);
            }
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

