/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.service.controllers;

import eu.dnetlib.api.functionality.ValidatorService;
import eu.dnetlib.api.functionality.ValidatorServiceException;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.repo.manager.service.controllers.MonitorApi;
import eu.dnetlib.repo.manager.shared.JobsOfUser;
import gr.uoa.di.driver.util.ServiceLocator;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.springframework.stereotype.Component;

@Component
public class MonitorApiImpl
implements MonitorApi {
    @Resource(name="validatorServiceLocator")
    private ServiceLocator<ValidatorService> validatorServiceLocator;
    private static final Logger LOGGER = Logger.getLogger(MonitorApiImpl.class);

    private ValidatorService getValidationService() {
        return (ValidatorService)this.validatorServiceLocator.getService();
    }

    public ServiceLocator<ValidatorService> getValidatorServiceLocator() {
        return this.validatorServiceLocator;
    }

    public void setValidatorServiceLocator(ServiceLocator<ValidatorService> validatorServiceLocator) {
        this.validatorServiceLocator = validatorServiceLocator;
    }

    @Override
    public JobsOfUser getJobsOfUser(@ApiParam(value="User email", required=true) String user, @ApiParam(value="Equals to filter job type on validation history page", required=true) String jobType, @ApiParam(value="Page number", required=true) String offset, @ApiParam(value="Null value", required=true) String limit, @ApiParam(value="Null value", required=true) String dateFrom, @ApiParam(value="Null value", required=true) String dateTo, @ApiParam(value="Equals to filter validation jobs", required=true) String validationStatus, @ApiParam(value="Always true", required=true) String includeJobsTotal) throws JSONException, ValidatorServiceException {
        LOGGER.debug((Object)("Getting jobs of user : " + user));
        LOGGER.debug((Object)(user + "/" + jobType + "/" + offset + "/" + dateFrom + "/" + dateTo + "/" + validationStatus + "/" + includeJobsTotal));
        JobsOfUser retJobs = new JobsOfUser();
        retJobs.setJobs(this.getValidationService().getStoredJobsNew(user, jobType, Integer.valueOf(Integer.parseInt(offset)), Integer.valueOf(Integer.parseInt(limit)), dateFrom, dateTo, validationStatus));
        if (Boolean.parseBoolean(includeJobsTotal)) {
            retJobs.setTotalJobs(this.getJobsTotalNumberOfUser(user, jobType, null));
            retJobs.setTotalJobsSuccessful(this.getJobsTotalNumberOfUser(user, jobType, "successful"));
            retJobs.setTotalJobsFailed(this.getJobsTotalNumberOfUser(user, jobType, "failed"));
            retJobs.setTotalJobsOngoing(this.getJobsTotalNumberOfUser(user, jobType, "ongoing"));
        }
        return retJobs;
    }

    private int getJobsTotalNumberOfUser(String user, String jobType, String validationStatus) throws ValidatorServiceException {
        return this.getValidationService().getStoredJobsTotalNumberNew(user, jobType, validationStatus);
    }

    @Override
    public int getJobsOfUserPerValidationStatus(String user, String jobType, String validationStatus) throws JSONException {
        LOGGER.debug((Object)("Getting job with validation status : " + validationStatus));
        try {
            return this.getValidationService().getStoredJobsTotalNumberNew(user, jobType, validationStatus);
        }
        catch (ValidatorServiceException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public StoredJob getJobSummary(String jobId, String groupBy) throws JSONException {
        LOGGER.debug((Object)("Getting job summary with id : " + jobId));
        try {
            return this.getValidationService().getStoredJob(Integer.parseInt(jobId), groupBy);
        }
        catch (ValidatorServiceException e) {
            e.printStackTrace();
            return null;
        }
    }
}

