/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.ws;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.clients.ws.DriverWebService;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;
import org.apache.log4j.Logger;

public abstract class BaseDriverWebService<S extends DriverService>
implements DriverWebService<S> {
    private static Logger logger = Logger.getLogger(BaseDriverWebService.class);
    protected S service = null;

    public void setService(S service) {
        this.service = service;
    }

    public final String identify() {
        ServiceIdentity identity = this.service.identify();
        if (identity != null) {
            return this.service.identify().toString();
        }
        return null;
    }

    public final void notify(String subscriptionId, String topic, String isId, String message) {
        logger.debug((Object)("Notification received: " + topic + ", message: " + message));
        try {
            Notification notification = new Notification(subscriptionId, message, topic, isId);
            this.service.notify(notification);
        }
        catch (Exception e) {
            logger.error((Object)"Error creating notification", (Throwable)e);
        }
    }

    public void start() {
        throw new UnsupportedOperationException();
    }
}

