/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.data.datasourcemanager.ws;

import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.data.DatasourceManagerService;
import eu.dnetlib.api.data.DatasourceManagerServiceException;
import eu.dnetlib.clients.data.datasourcemanager.ws.Converter;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.domain.enabling.Notification;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;

public class DatasourceManagerServiceClient
implements DatasourceManagerService {
    private static Logger logger = Logger.getLogger(DatasourceManagerServiceClient.class);
    private eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService client = null;

    public void setClient(eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService client) {
        this.client = client;
    }

    public eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService getClient() {
        return this.client;
    }

    public void setWebService(Object webService) {
        this.client = (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService)webService;
    }

    public boolean addDatasource(Repository repository) throws DatasourceManagerServiceException {
        logger.debug((Object)"Adding datasource");
        try {
            this.client.addDatasource(Converter.convertToDsmRepo(repository));
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error adding datasource. ", (Throwable)e);
        }
        return false;
    }

    public boolean deleteDatasource(String dsId) throws DatasourceManagerServiceException {
        logger.debug((Object)"deleting datasource");
        try {
            this.client.deleteDatasource(dsId);
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error deleting datasource. ", (Throwable)e);
        }
        return false;
    }

    public Repository getDatasource(String dsId) throws DatasourceManagerServiceException {
        logger.debug((Object)"getting datasource");
        Repository retRepo = null;
        try {
            retRepo = Converter.convertToValRepo(this.client.getDatasource(dsId));
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error getting datasource. ", (Throwable)e);
        }
        return retRepo;
    }

    public List<Repository> listAllDatasources() throws DatasourceManagerServiceException {
        logger.debug((Object)"getting datasource list");
        List<Repository> retList = null;
        try {
            retList = Converter.convertToValRepoList(this.client.listAllDatasources());
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error getting datasource list. ", (Throwable)e);
        }
        return retList;
    }

    public List<Repository> listDatasourcesUsingFilter(String compliance, String contentDescription, String iisProcessingWorkflow, String collectedFrom) throws DatasourceManagerServiceException {
        logger.debug((Object)"getting datasource list using filters");
        List<Repository> retList = null;
        try {
            retList = Converter.convertToValRepoList(this.client.listDatasourcesUsingFilter(compliance, contentDescription, iisProcessingWorkflow, collectedFrom));
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error getting datasource list using filters. ", (Throwable)e);
        }
        return retList;
    }

    public boolean updateLevelOfCompliance(String dsId, String ifaceId, String level) throws DatasourceManagerServiceException {
        logger.debug((Object)"updating level of compliance");
        Boolean ret = false;
        try {
            ret = this.client.updateLevelOfCompliance(dsId, ifaceId, level);
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error updating level of compliance. ", (Throwable)e);
        }
        return ret;
    }

    public boolean updateBaseUrl(String dsId, String ifaceId, String baseUrl) throws DatasourceManagerServiceException {
        logger.debug((Object)"updating baseurl");
        Boolean ret = false;
        try {
            ret = this.client.updateBaseUrl(dsId, ifaceId, baseUrl);
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error updating baseurl. ", (Throwable)e);
        }
        return ret;
    }

    public boolean updateActivationStatus(String dsId, String ifaceId, boolean active) throws DatasourceManagerServiceException {
        logger.debug((Object)"updating activation status");
        Boolean ret = false;
        try {
            ret = this.client.updateActivationStatus(dsId, ifaceId, active);
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error updating activation status. ", (Throwable)e);
        }
        return ret;
    }

    public boolean updateContentDescription(String dsId, String ifaceId, String desc) throws DatasourceManagerServiceException {
        logger.debug((Object)"updating content description");
        Boolean ret = false;
        try {
            ret = this.client.updateContentDescription(dsId, ifaceId, desc);
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error updating content description. ", (Throwable)e);
        }
        return ret;
    }

    public boolean setIisProcessingWorkflow(String dsId, String ifaceId, String wf) throws DatasourceManagerServiceException {
        logger.debug((Object)"setting processing workflow");
        Boolean ret = false;
        try {
            ret = this.client.setIisProcessingWorkflow(dsId, ifaceId, wf);
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error setting processing workflow. ", (Throwable)e);
        }
        return ret;
    }

    public boolean updateExtraField(String dsId, String ifaceId, String field, String value, boolean preserveOriginal) throws DatasourceManagerServiceException {
        logger.debug((Object)"updating extra field");
        Boolean ret = false;
        try {
            ret = this.client.updateExtraField(dsId, ifaceId, field, value, preserveOriginal);
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error updating extra field. ", (Throwable)e);
        }
        return ret;
    }

    public boolean updateAccessParam(String dsId, String ifaceId, String field, String value, boolean preserveOriginal) throws DatasourceManagerServiceException {
        logger.debug((Object)"updating access param");
        Boolean ret = false;
        try {
            ret = this.client.updateAccessParam(dsId, ifaceId, field, value, preserveOriginal);
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error updating access param. ", (Throwable)e);
        }
        return ret;
    }

    public boolean deleteAccessParamOrExtraField(String dsId, String ifaceId, String field) throws DatasourceManagerServiceException {
        logger.debug((Object)"deleting access param or extra field");
        Boolean ret = false;
        try {
            ret = this.client.deleteAccessParamOrExtraField(dsId, ifaceId, field);
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error deleting access param or extra field. ", (Throwable)e);
        }
        return ret;
    }

    public boolean addInterface(String dsId, RepositoryInterface iface) throws DatasourceManagerServiceException {
        logger.debug((Object)"adding interface");
        Boolean ret = false;
        try {
            ret = this.client.addInterface(dsId, Converter.convertToDsmIface(iface));
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error adding interface. ", (Throwable)e);
        }
        return ret;
    }

    public boolean deleteInterface(String dsId, String ifaceId) throws DatasourceManagerServiceException {
        logger.debug((Object)"deleting interface");
        Boolean ret = false;
        try {
            ret = this.client.deleteInterface(dsId, ifaceId);
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error deleting interface. ", (Throwable)e);
        }
        return ret;
    }

    public boolean updateSQL(String dsId, String sql, boolean delete) throws DatasourceManagerServiceException {
        logger.debug((Object)"updating sql");
        Boolean ret = false;
        try {
            ret = this.client.updateSQL(dsId, sql, delete);
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"Error updating sql. ", (Throwable)e);
        }
        return ret;
    }

    public Date findNextScheduledExecution(String dsId, String ifaceId) throws DatasourceManagerServiceException {
        logger.debug((Object)"finding next scheduled job");
        Date ret = null;
        try {
            ret = this.client.findNextScheduledExecution(dsId, ifaceId);
        }
        catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
            logger.error((Object)"error finding next scheduled job.", (Throwable)e);
        }
        return ret;
    }

    public ServiceIdentity identify() {
        throw new UnsupportedOperationException();
    }

    public void notify(Notification notification) throws DriverServiceException {
        throw new UnsupportedOperationException();
    }
}

