package eu.dnetlib.loginservice.controllers;

import eu.dnetlib.loginservice.properties.Properties;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@RestController
public class HealthController {
    private final Logger log = Logger.getLogger(this.getClass());
    private final Properties properties;

    @Autowired
    public HealthController(Properties properties) {
        this.properties = properties;
    }

    @RequestMapping(value = {"", "/health_check"}, method = RequestMethod.GET)
    public String hello() {
        log.debug("Hello from Login service!");
        return "Hello from Login service!";
    }

    @PreAuthorize("hasAnyAuthority('PORTAL_ADMINISTRATOR')")
    @RequestMapping(value = "/health_check/advanced", method = RequestMethod.GET)
    public Map<String, String> checkEverything() {
        Map<String, String> response = new HashMap<>();
        response.put("authentication.domain", properties.getDomain());
        response.put("authentication.redis.host", properties.getRedis().getHost());
        response.put("authentication.oidc.id", properties.getOidc().getId());
        response.put("authentication.oidc.secret", properties.getOidc().getSecret());
        response.put("authentication.oidc.issuer", properties.getOidc().getIssuer());
        response.put("authentication.oidc.home", properties.getOidc().getHome());
        response.put("authentication.oidc.logout", properties.getOidc().getLogout());
        response.put("authentication.oidc.scope", properties.getOidc().getScope());
        response.put("authentication.redirect", properties.getRedirect());
        return response;
    }
}
