/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.loginservice.security.oidc;

import eu.dnetlib.loginservice.properties.Properties;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
public class OpenAIRELogoutSuccessHandler
implements LogoutSuccessHandler {
    private final Properties properties;

    @Autowired
    public OpenAIRELogoutSuccessHandler(Properties properties) {
        this.properties = properties;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        HttpSession session = request.getSession();
        String redirect = (String)session.getAttribute("redirect");
        session.removeAttribute("redirect");
        if (redirect == null) {
            redirect = this.properties.getRedirect();
        }
        session.invalidate();
        response.sendRedirect(this.properties.getOidc().getLogout() + redirect);
    }
}

