/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.util;

import eu.dnetlib.pace.clustering.ClusteringClass;
import eu.dnetlib.pace.clustering.ClusteringFunction;
import eu.dnetlib.pace.tree.support.Comparator;
import eu.dnetlib.pace.tree.support.ComparatorClass;
import eu.dnetlib.pace.util.PaceException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class PaceResolver
implements Serializable {
    public static final Reflections CLUSTERING_RESOLVER = new Reflections("eu.dnetlib.pace.clustering", new Scanner[0]);
    public static final Reflections COMPARATOR_RESOLVER = new Reflections("eu.dnetlib.pace.tree", new Scanner[0]);
    private final Map<String, Class<ClusteringFunction>> clusteringFunctions = CLUSTERING_RESOLVER.getTypesAnnotatedWith(ClusteringClass.class).stream().filter(ClusteringFunction.class::isAssignableFrom).collect(Collectors.toMap(cl -> cl.getAnnotation(ClusteringClass.class).value(), cl -> cl));
    private final Map<String, Class<Comparator>> comparators = COMPARATOR_RESOLVER.getTypesAnnotatedWith(ComparatorClass.class).stream().filter(Comparator.class::isAssignableFrom).collect(Collectors.toMap(cl -> cl.getAnnotation(ComparatorClass.class).value(), cl -> cl));

    public ClusteringFunction getClusteringFunction(String name, Map<String, Integer> params) throws PaceException {
        try {
            return this.clusteringFunctions.get(name).getDeclaredConstructor(Map.class).newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PaceException(name + " not found ", e);
        }
    }

    public Comparator getComparator(String name, Map<String, String> params) throws PaceException {
        try {
            return this.comparators.get(name).getDeclaredConstructor(Map.class).newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
            throw new PaceException(name + " not found ", e);
        }
    }
}

