/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree.support;

import eu.dnetlib.pace.tree.support.AggType;
import eu.dnetlib.pace.tree.support.FieldStats;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TreeNodeStats
implements Serializable {
    private Map<String, FieldStats> results = new HashMap<String, FieldStats>();

    public Map<String, FieldStats> getResults() {
        return this.results;
    }

    public void addFieldStats(String id, FieldStats fieldStats) {
        this.results.put(id, fieldStats);
    }

    public int fieldsCount() {
        return this.results.size();
    }

    public int undefinedCount() {
        int undefinedCount = 0;
        for (FieldStats fs : this.results.values()) {
            if (fs.getResult() != -1.0) continue;
            ++undefinedCount;
        }
        return undefinedCount;
    }

    public double scoreSum() {
        double scoreSum = 0.0;
        for (FieldStats fs : this.results.values()) {
            if (!(fs.getResult() >= 0.0)) continue;
            scoreSum += fs.getResult();
        }
        return scoreSum;
    }

    public double weightSum() {
        double weightSum = 0.0;
        for (FieldStats fs : this.results.values()) {
            if (!(fs.getResult() >= 0.0) && (!(fs.getResult() < 0.0) || !fs.isCountIfUndefined())) continue;
            weightSum += fs.getWeight();
        }
        return weightSum;
    }

    public double weightedScoreSum() {
        double weightedScoreSum = 0.0;
        for (FieldStats fs : this.results.values()) {
            if (!(fs.getResult() >= 0.0)) continue;
            weightedScoreSum += fs.getResult() * fs.getWeight();
        }
        return weightedScoreSum;
    }

    public double max() {
        double max = -1.0;
        for (FieldStats fs : this.results.values()) {
            if (!(fs.getResult() > max)) continue;
            max = fs.getResult();
        }
        return max;
    }

    public double min() {
        double min = 100.0;
        for (FieldStats fs : this.results.values()) {
            if (!(fs.getResult() < min) || !(fs.getResult() >= 0.0) && (fs.getResult() != -1.0 || !fs.isCountIfUndefined())) continue;
            min = fs.getResult();
        }
        return min;
    }

    public double or() {
        for (FieldStats fieldStats : this.results.values()) {
            if (!(fieldStats.getResult() >= fieldStats.getThreshold())) continue;
            return 1.0;
        }
        return 0.0;
    }

    public double and() {
        for (FieldStats fieldStats : this.results.values()) {
            if (!(fieldStats.getResult() == -1.0 ? fieldStats.isCountIfUndefined() : fieldStats.getResult() < fieldStats.getThreshold())) continue;
            return 0.0;
        }
        return 1.0;
    }

    public double getFinalScore(AggType aggregation) {
        switch (aggregation) {
            case AVG: {
                return this.scoreSum() / (double)this.fieldsCount();
            }
            case SUM: {
                return this.scoreSum();
            }
            case MAX: {
                return this.max();
            }
            case MIN: {
                return this.min();
            }
            case W_MEAN: {
                return this.weightedScoreSum() / this.weightSum();
            }
            case OR: {
                return this.or();
            }
            case AND: {
                return this.and();
            }
        }
        return 0.0;
    }
}

