/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.Levenstein;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.tree.support.AbstractComparator;
import eu.dnetlib.pace.tree.support.ComparatorClass;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ComparatorClass(value="levensteinTitle")
public class LevensteinTitle
extends AbstractComparator {
    private static final Log log = LogFactory.getLog(LevensteinTitle.class);

    public LevensteinTitle(Map<String, String> params) {
        super(params, (AbstractStringDistance)new Levenstein());
    }

    public LevensteinTitle(double w) {
        super(w, (AbstractStringDistance)new Levenstein());
    }

    protected LevensteinTitle(double w, AbstractStringDistance ssalgo) {
        super(w, ssalgo);
    }

    @Override
    public double distance(String a, String b, Config conf) {
        String cb;
        String ca = this.cleanup(a);
        boolean check = this.checkNumbers(ca, cb = this.cleanup(b));
        if (check) {
            return 0.5;
        }
        return this.normalize(this.ssalgo.score(ca, cb), ca.length(), cb.length());
    }

    private double normalize(double score, int la, int lb) {
        return 1.0 - Math.abs(score) / (double)Math.max(la, lb);
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    protected double normalize(double d) {
        return 1.0 / Math.pow(Math.abs(d) + 1.0, 0.1);
    }
}

