/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldListImpl;
import eu.dnetlib.pace.model.FieldValueImpl;
import java.io.Serializable;
import java.util.List;

public class FieldDef
implements Serializable {
    public static final String PATH_SEPARATOR = "/";
    private String name;
    private String path;
    private Type type;
    private boolean overrideMatch;
    private int size = -1;
    private int length = -1;

    public Field apply(Type type, String s) {
        switch (type) {
            case Int: {
                return new FieldValueImpl(type, this.name, Integer.parseInt(s));
            }
            case String: {
                return new FieldValueImpl(type, this.name, s);
            }
            case List: {
                return new FieldListImpl(this.name, type);
            }
        }
        throw new IllegalArgumentException("Casting not implemented for type " + (Object)((Object)type));
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getPathList() {
        return Lists.newArrayList((Iterable)Splitter.on((String)PATH_SEPARATOR).split((CharSequence)this.getPath()));
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isOverrideMatch() {
        return this.overrideMatch;
    }

    public void setOverrideMatch(boolean overrideMatch) {
        this.overrideMatch = overrideMatch;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }
}

