package eu.dnetlib.msro.openaireplus.workflows.nodes.repohi;

import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class RetrieveInterfaceInfoJobNode extends SimpleJobNode {

	@Autowired
	private LocalDatasourceManager<Datasource<?, ?, ?>, Api<ApiParam>> dsManager;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final String datasourceId = token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_ID);
		final String interfaceID = token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE);

		final Api<ApiParam> api = dsManager.getApis(datasourceId)
			.stream()
			.filter(a -> a.getId().equals(interfaceID))
			.findFirst()
			.orElseThrow(() -> new MSROException("Api not found"));

		final String contentDescription = api.getContentdescription();
		token.getEnv().setAttribute("objectStoreContentDescription", contentDescription);

		final String basePath = api.getApiParams()
			.stream()
			.filter(ap -> ap.getParam().equals("basePath"))
			.map(ap -> ap.getValue())
			.findFirst()
			.orElseThrow(() -> new MSROException("Param 'basePath' not found"));

		token.getEnv().setAttribute("objectStoreBasePath", basePath);

		return Arc.DEFAULT_ARC;
	}

}
