<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="updateLegalNames"/>
	</ARCS>
</NODE>
<NODE name="updateLegalNames" type="ExecuteSql">
	<DESCRIPTION>update the name of the children organizations</DESCRIPTION>
	<PARAMETERS>
		<PARAM managedBy="system" name="sqlInClasspath" required="true" type="boolean">false</PARAM>
		<PARAM managedBy="system" name="dbProperty" required="true" type="string">dnet.openaire.db.name</PARAM>
		<PARAM managedBy="system" name="sql" required="true" type="string">
with recursive recusive_rels(org1, org2, level) as (
      select r.org1, r.org2, 1 as level
      from dsm_organization_rels r
      where r.reltype = 'IsChildOf'
      union all
      select r.org1, rr.org2, rr.level + 1
      from dsm_organization_rels r join recusive_rels rr on r.org2 = rr.org1
      where r.reltype = 'IsChildOf'
)
update dsm_organizations dso
set legalname = k.new_name
from (select o1.id as id, o1.legalname as old_name,  o2.legalname||', '|| o1.legalname as new_name
        from (select rr.*, max(rr.level) over (partition by rr.org1) as maxlevel from recusive_rels rr) t
        join dsm_organizations o1 on (t.org1 = o1.id)
        join dsm_organizations o2 on (t.org2 = o2.id)
        where t.level = t.maxlevel and o1.legalname not like o2.legalname||', %' and o1.collectedfrom = '$params.("dataprovider:id")$') as k
where dso.id = k.id;
		</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
