<!-- TODO: nodi per la spark configuration -->


<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="obtainParams"/>
	</ARCS>
</NODE>

<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Obtain data source params</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="PREPARE_ENV_COLLECTION"/>
	</ARCS>
</NODE>

<NODE name="PREPARE_ENV_COLLECTION" type="PrepareEnvValidationAlertsHadoopJobNode">
    <DESCRIPTION>Set in the environment all the variable needed to the collection oozie job</DESCRIPTION>
    <PARAMETERS>
        <PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("harv_id")$</PARAM>
        <PARAM required="false" type="string" name="overrideRegisteredByEmail" managedBy="user"></PARAM>
    </PARAMETERS>
    <ARCS>
        <ARC to="VERIFY_SUBSCRIPTION"/>
    </ARCS>
</NODE>

<NODE name="VERIFY_SUBSCRIPTION" type="VerifyValidationAlertsSubscriptionJobNode">
    <DESCRIPTION>Verify if the subscription has been created</DESCRIPTION>
    <PARAMETERS />
    <ARCS>
        <ARC to="ALERT_NOTIFICATIONS"/>
    </ARCS>
</NODE>

<NODE name="ALERT_NOTIFICATIONS" type="SubmitDnetHadoopJobNode">
    <DESCRIPTION>Start the Hadoop Job</DESCRIPTION>
    <PARAMETERS>
        <PARAM managedBy="system" name="hadoopJob" required="true" type="string">executeOozieJob</PARAM>
        <PARAM managedBy="user" name="cluster" required="true" type="string" function="validValues(['IIS','DHP'])">IIS</PARAM>
        <PARAM managedBy="system" name="envParams" required="true" type="string">
            {
                "apiDescription":"apiDescription",
                "dataSourceInfo":"dataSourceInfo",
                "mdStoreInputId":"mdId",
                "outputDir": "hdfsValidationAlertsDir",
                "esIndexName": "validationAlertsIndexName",
                "esIndexHost": "validationAlertsIndexHost",
                "brokerApiBaseUrl": "brokerApiBaseUrl",
                "oozie.wf.application.path":"oozieWfPath"
            }
        </PARAM>
        <PARAM managedBy="system" name="params" required="true" type="string">
            {
                "collection_java_xmx" : "-Xmx300m"
            }
        </PARAM>
        <PARAM managedBy="system" name="oozieReportActionsCsv" required="true" type="string">BeginRead,GenerateAlertNotifications,IndexAlertNotifications,EndRead</PARAM>
    </PARAMETERS>
    <ARCS>
        <ARC to="success"/>
    </ARCS>
</NODE>

