package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp.message;

import java.util.Arrays;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import eu.dnetlib.dhp.message.Message;
import eu.dnetlib.msro.rmi.MSROException;

@Controller
public class DnetMessageManagerController {

	@Resource
	private DnetMessageManager dnetMessageManager;

	private static final Log log = LogFactory.getLog(DnetMessageManagerController.class);

	@RequestMapping(value = "/dhp/message", method = {
		RequestMethod.PUT, RequestMethod.POST
	})
	public @ResponseBody List<String> registerMessage(@RequestBody(required = true) final Message message) throws MSROException {
		dnetMessageManager.registerMessage(message);
		return Arrays.asList("done");
	}

	@ExceptionHandler(Exception.class)
	@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
	public @ResponseBody ErrorMessage handleException(final Exception e) {
		log.error("Error processing http method", e);
		return new ErrorMessage(e);
	}

	public class ErrorMessage {

		private final String message;
		private final String stacktrace;

		public ErrorMessage(final Exception e) {
			this(e.getMessage(), ExceptionUtils.getStackTrace(e));
		}

		public ErrorMessage(final String message, final String stacktrace) {
			this.message = message;
			this.stacktrace = stacktrace;
		}

		public String getMessage() {
			return this.message;
		}

		public String getStacktrace() {
			return this.stacktrace;
		}

	}
}
