package eu.dnetlib.msro.openaireplus.workflows.nodes.consistency;

import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class FindInvalidMetaWorkflowsJobNode extends SimpleJobNode {

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Autowired
	private LocalDatasourceManager<Datasource<?, ?, ?>, Api<?>> dsManager;

	private static final Log log = LogFactory.getLog(FindInvalidMetaWorkflowsJobNode.class);

	private boolean deleteInvalidProfiles = false;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final ISLookUpService lookup = serviceLocator.getService(ISLookUpService.class);
		final ISRegistryService registry = serviceLocator.getService(ISRegistryService.class);

		final Set<String> valids = new HashSet<>();
		for (final String dsId : dsManager.listManagedDatasourceIds()) {
			for (final Api<?> api : dsManager.getApis(dsId)) {
				valids.add(dsId + "|" + api.getId());
			}
		}

		final String q = "for $x in collection(' /db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') \n" +
			"where $x//DATAPROVIDER/@id and $x//DATAPROVIDER/@interface\n" +
			"return concat($x//RESOURCE_IDENTIFIER/@value,'@@@',$x//DATAPROVIDER/@id,'|',$x//DATAPROVIDER/@interface)";

		int count = 0;
		int countInvalids = 0;
		int countDeleted = 0;
		for (final String s : lookup.quickSearchProfile(q)) {
			count++;
			final String metaWfId = StringUtils.substringBefore(s, "@@@");
			final String dsapi = StringUtils.substringAfter(s, "@@@");
			if (!valids.contains(dsapi)) {
				log.warn("Invalid metaWf: " + metaWfId);
				countInvalids++;
				if (deleteInvalidProfiles) {
					registry.deleteProfile(metaWfId);
					log.info(" -- Deleted");
					countDeleted++;
				}

			}
		}

		token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "total", count);
		token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "invalid", countInvalids);
		token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "deleted", countDeleted);

		return Arc.DEFAULT_ARC;
	}

	public boolean isDeleteInvalidProfiles() {
		return deleteInvalidProfiles;
	}

	public void setDeleteInvalidProfiles(final boolean deleteInvalidProfiles) {
		this.deleteInvalidProfiles = deleteInvalidProfiles;
	}
}
