/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.google.common.collect.Queues;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

public class FindSearchServicesJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(FindSearchServicesJobNode.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Value(value="${dnet.openaire.service.search.lookup.xquery}")
    private String xquery;

    public String execute(NodeToken token) throws ISLookUpException, MSROException {
        log.info((Object)("lookup for search service: " + this.getXquery()));
        List searchServiceIds = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(this.getXquery());
        log.info((Object)("SearchService found: " + searchServiceIds.size()));
        LinkedBlockingQueue q = Queues.newLinkedBlockingQueue((Iterable)searchServiceIds);
        if (searchServiceIds.isEmpty()) {
            return "notFound";
        }
        token.getEnv().setTransientAttribute("searchService_ids", (Object)q);
        return "found";
    }

    public String getXquery() {
        return this.xquery;
    }

    public void setXquery(String xquery) {
        this.xquery = xquery;
    }
}

