/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.common.logging.DnetLogger;
import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.schema.mdstore.Provenance;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.DsmNotFoundException;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PrepareEnvCollectHadoopJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareEnvCollectHadoopJobNode.class);
    public static final String METADATA_IDENTIFIER_PATH = "metadata_identifier_path";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private final long ONE_DAY = 86400000L;
    @Resource(name="msroWorkflowLogger")
    private DnetLogger dnetLogger;
    @Autowired
    private LocalDatasourceManager<?, ?> dsManager;
    private String mdId;
    private String collectionMode;
    private String fromDateOverride;
    private String untilDateOverride;
    private String metadataEncoding = "XML";
    private int maxNumberOfRetry = 5;
    private int requestDelay = 0;
    private int retryDelay = 60;
    private int connectTimeOut = 30;
    private int readTimeOut = 60;
    @Value(value="${dnet.openaire.dhp.collection.app.path}")
    private String oozieWfPath;
    @Value(value="${dnet.openaire.dhp.dnetMessageManagerURL}")
    private String dnetMessageManagerURL;

    protected String execute(NodeToken token) throws Exception {
        String dsId = token.getEnv().getAttribute("parentDatasourceId");
        log.info((Object)("dsId: " + dsId));
        String apiId = token.getEnv().getAttribute("dataprovider:interface");
        log.info((Object)("apiId: " + apiId));
        Optional<ApiDescriptor> opt = this.dsManager.getApis(dsId).stream().filter(a -> a.getId().equals(apiId)).map(a -> {
            ApiDescriptor res = new ApiDescriptor();
            res.setBaseUrl(a.getBaseurl());
            res.setId(a.getId());
            res.setProtocol(a.getProtocol());
            res.getParams().put(METADATA_IDENTIFIER_PATH, a.getMetadataIdentifierPath());
            res.getParams().putAll(a.getApiParams().stream().map(o -> o).collect(Collectors.toMap(ApiParam::getParam, ApiParam::getValue)));
            return res;
        }).findFirst();
        if (opt.isPresent()) {
            token.getEnv().setAttribute("mdId", this.getMdId());
            token.getEnv().setAttribute("collectionMode", this.getCollectionMode());
            token.getEnv().setAttribute("metadataEncoding", this.getMetadataEncoding());
            token.getEnv().setAttribute("oozieWfPath", this.getOozieWfPath());
            token.getEnv().setAttribute("dnetMessageManagerURL", this.getDnetMessageManagerURL());
            token.getEnv().setAttribute("maxNumberOfRetry", (Object)this.getMaxNumberOfRetry());
            token.getEnv().setAttribute("requestDelay", (Object)this.getRequestDelay());
            token.getEnv().setAttribute("retryDelay", (Object)this.getRetryDelay());
            token.getEnv().setAttribute("connectTimeOut", (Object)this.getConnectTimeOut());
            token.getEnv().setAttribute("readTimeOut", (Object)this.getReadTimeOut());
            ApiDescriptor api = opt.get();
            if ("INCREMENTAL".equals(this.getCollectionMode())) {
                String fromDate = this.calculateFromDate(token);
                log.info((Object)("Incremental Harvesting from: " + fromDate));
                if (StringUtils.isNotBlank((CharSequence)fromDate)) {
                    api.getParams().put("fromDate", fromDate);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.getUntilDateOverride())) {
                api.getParams().put("untilDate", this.getUntilDateOverride());
            }
            token.getEnv().setAttribute("apiDescription", new Gson().toJson((Object)api));
            Provenance provenance = new Provenance();
            provenance.setDatasourceId(dsId);
            Datasource ds = this.dsManager.getDs(dsId);
            provenance.setDatasourceName(ds.getOfficialname());
            provenance.setNsPrefix(ds.getNamespaceprefix());
            String dsProvenance = new Gson().toJson((Object)provenance);
            log.info((Object)("datasource provenance: " + dsProvenance));
            token.getEnv().setAttribute("dataSourceInfo", dsProvenance);
            token.getEnv().setAttribute("timestamp", "" + System.currentTimeMillis());
            token.getEnv().setAttribute("identifierPath", (String)api.getParams().get(METADATA_IDENTIFIER_PATH));
            token.getEnv().setAttribute("workflowId", token.getProcess().getEnv().getAttribute("system:processId"));
            token.getEnv().setAttribute("dataprovider:interface:baseUrl", api.getBaseUrl());
            token.getEnv().setAttribute("dataprovider:protocol", api.getProtocol());
            Map params = api.getParams();
            if (params != null) {
                for (Map.Entry e : params.entrySet()) {
                    token.getEnv().setAttribute("dataprovider:" + (String)e.getKey(), (String)e.getValue());
                }
            }
            return Arc.DEFAULT_ARC;
        }
        throw new DsmNotFoundException("cannot find ds interface: " + apiId);
    }

    private String findCurrentWfProfileId(NodeToken token) throws MSROException {
        String p1 = token.getEnv().getAttribute("system:profileId");
        if (p1 != null && !p1.isEmpty()) {
            return p1;
        }
        String p2 = token.getFullEnv().getAttribute("system:profileId");
        if (p2 != null && !p2.isEmpty()) {
            return p2;
        }
        String p3 = token.getProcess().getEnv().getAttribute("system:profileId");
        if (p3 != null && !p3.isEmpty()) {
            return p3;
        }
        throw new MSROException("Missing property in env: system:profileId");
    }

    private String calculateFromDate(NodeToken token) throws MSROException {
        if (StringUtils.isNotBlank((CharSequence)this.getFromDateOverride())) {
            log.info((Object)("using override FROM_DATE for incremental harvesting: " + this.getFromDateOverride()));
            return this.getFromDateOverride();
        }
        String profId = this.findCurrentWfProfileId(token);
        long d = this.findLastSuccessStartDate(profId);
        return d > 0L ? new SimpleDateFormat(DATE_FORMAT).format(new Date(d - 86400000L)) : null;
    }

    private long findLastSuccessStartDate(String profId) {
        long res = -1L;
        Iterator iter = this.dnetLogger.find("system:profileId", profId);
        while (iter.hasNext()) {
            long curr;
            Map map = (Map)iter.next();
            if (!"true".equalsIgnoreCase((String)map.get("system:isCompletedSuccessfully")) || (curr = NumberUtils.toLong((String)((String)map.get("system:startDate")), (long)-1L)) <= res) continue;
            res = curr;
        }
        return res;
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }

    public String getCollectionMode() {
        return this.collectionMode;
    }

    public void setCollectionMode(String collectionMode) {
        this.collectionMode = collectionMode;
    }

    public String getOozieWfPath() {
        return this.oozieWfPath;
    }

    public void setOozieWfPath(String oozieWfPath) {
        this.oozieWfPath = oozieWfPath;
    }

    public String getMetadataEncoding() {
        return this.metadataEncoding;
    }

    public void setMetadataEncoding(String metadataEncoding) {
        this.metadataEncoding = metadataEncoding;
    }

    public String getFromDateOverride() {
        return this.fromDateOverride;
    }

    public void setFromDateOverride(String fromDateOverride) {
        this.fromDateOverride = fromDateOverride;
    }

    public String getUntilDateOverride() {
        return this.untilDateOverride;
    }

    public void setUntilDateOverride(String untilDateOverride) {
        this.untilDateOverride = untilDateOverride;
    }

    public int getMaxNumberOfRetry() {
        return this.maxNumberOfRetry;
    }

    public void setMaxNumberOfRetry(int maxNumberOfRetry) {
        this.maxNumberOfRetry = maxNumberOfRetry;
    }

    public int getRequestDelay() {
        return this.requestDelay;
    }

    public void setRequestDelay(int requestDelay) {
        this.requestDelay = requestDelay;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(int readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public String getDnetMessageManagerURL() {
        return this.dnetMessageManagerURL;
    }

    public void setDnetMessageManagerURL(String dnetMessageManagerURL) {
        this.dnetMessageManagerURL = dnetMessageManagerURL;
    }
}

