/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.consistency;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.DatasourceManagerClients;
import eu.dnetlib.enabling.datasources.LocalOpenaireDatasourceManager;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FindInvalidRepoProfilesJobNode
extends SimpleJobNode
implements ProgressJobNode {
    @Autowired
    private LocalOpenaireDatasourceManager dsManager;
    @Autowired
    private DatasourceManagerClients dsManagerClient;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private int current = 0;
    private int total = 0;
    private boolean deleteInvalidProfiles = false;
    private boolean registerMissingProfiles = false;
    private static final Log log = LogFactory.getLog(FindInvalidRepoProfilesJobNode.class);

    protected String execute(NodeToken token) throws Exception {
        Map<String, AtomicInteger> validIds = this.dsManagerClient.searchSQL("SELECT id FROM dsm_datasources", new HashMap()).stream().map(m -> (String)m.get("id")).collect(Collectors.toMap(s -> s, s -> new AtomicInteger(0)));
        List list = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') return concat($x//DATASOURCE_ORIGINAL_ID, ' @@@ ', $x//RESOURCE_IDENTIFIER/@value)");
        this.current = 0;
        this.total = list.size() + validIds.size();
        int errorInvalidProfiles = 0;
        int errorUnregisteredProfiles = 0;
        int errorTooManyProfiles = 0;
        for (String string : list) {
            ++this.current;
            String oid = StringUtils.substringBefore((String)string, (String)"@@@").trim();
            String profId = StringUtils.substringAfter((String)string, (String)"@@@").trim();
            log.info((Object)("Evaluating ds: " + oid));
            if (validIds.containsKey(oid)) {
                validIds.get(oid).incrementAndGet();
                continue;
            }
            log.warn((Object)("Invalid profile " + profId + ", openaireId " + oid + " not registered properly"));
            ++errorInvalidProfiles;
            if (!this.deleteInvalidProfiles) continue;
            log.warn((Object)("  - Deleting profile " + profId));
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).deleteProfile(profId);
        }
        for (Map.Entry entry : validIds.entrySet()) {
            ++this.current;
            String dsId = (String)entry.getKey();
            int n = ((AtomicInteger)entry.getValue()).get();
            if (n == 0) {
                ++errorUnregisteredProfiles;
                log.warn((Object)("Missing profile for ds " + dsId));
                if (!this.registerMissingProfiles) continue;
                this.dsManager.setManaged(dsId, this.dsManager.isManaged(dsId));
                continue;
            }
            if (n <= 1) continue;
            ++errorTooManyProfiles;
            log.error((Object)("Too many profiles registerd " + n + " for ds " + dsId));
        }
        token.getEnv().setAttribute("mainlog:errorInvalidProfiles", (Object)errorInvalidProfiles);
        token.getEnv().setAttribute("mainlog:errorUnregisteredProfiles", (Object)errorUnregisteredProfiles);
        token.getEnv().setAttribute("mainlog:errorTooManyProfiles", (Object)errorTooManyProfiles);
        return Arc.DEFAULT_ARC;
    }

    public ProgressProvider getProgressProvider() {
        return new ProgressProvider(){

            public int getTotalValue() {
                return FindInvalidRepoProfilesJobNode.this.total;
            }

            public int getCurrentValue() {
                return FindInvalidRepoProfilesJobNode.this.current;
            }

            public boolean isInaccurate() {
                return false;
            }
        };
    }

    public boolean isDeleteInvalidProfiles() {
        return this.deleteInvalidProfiles;
    }

    public void setDeleteInvalidProfiles(boolean deleteInvalidProfiles) {
        this.deleteInvalidProfiles = deleteInvalidProfiles;
    }

    public boolean isRegisterMissingProfiles() {
        return this.registerMissingProfiles;
    }

    public void setRegisterMissingProfiles(boolean registerMissingProfiles) {
        this.registerMissingProfiles = registerMissingProfiles;
    }
}

