package eu.dnetlib.msro.openaireplus.workflows.nodes.repohi;

import java.io.StringReader;
import javax.annotation.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class RetrieveInterfaceInfoJobNode extends SimpleJobNode {

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		String datasourceId = token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_ID);
		String interfaceID = token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE);
		final String profile = serviceLocator.getService(ISLookUpService.class).getResourceProfile(datasourceId);
		final Document doc = new SAXReader().read(new StringReader(profile));
		final Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + interfaceID + "']");

		String contentDescription = ifcNode.valueOf("./@contentDescription");
		token.getEnv().setAttribute("objectStoreContentDescription", contentDescription);

		final Node acProtNode = doc.selectSingleNode("//INTERFACE[@id='" + interfaceID + "']/ACCESS_PROTOCOL");

		String basePath = acProtNode.valueOf("./@basePath");
		token.getEnv().setAttribute("objectStoreBasePath", basePath);

		return Arc.DEFAULT_ARC;
	}

}
