<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="xs" version="1.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>
	<xsl:param name="quote">"</xsl:param>

	<xsl:template name="getJson">
		<xsl:param name="varName"/>
		<xsl:param name="value"/>
		<xsl:value-of select="concat($quote, $varName, $quote, ':', $quote, $value, $quote)"/>
	</xsl:template>


	<xsl:template match="/">

		<xsl:variable name="prefix" select="string('nwo_________')"/>

		<record
		>

			<xsl:copy-of select=".//*[local-name()='header']"/>

			<metadata>
				<ROWS>
					<xsl:variable name="projectId" select="concat($namespacePrefix, '::',  normalize-space(.//column[@name='ProjectID']))"/>
					<xsl:variable name="startDate" select=".//column[@name='Werk startdat']"/>
					<xsl:variable name="endDate" select=".//column[@name='Werk einddat']"/>
					<xsl:variable name="dossiernr">
						<xsl:call-template name="getJson">
							<xsl:with-param name="varName">dossiernr</xsl:with-param>
							<xsl:with-param name="value">
								<xsl:value-of select=".//column[@name='Dossiernr']"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:variable name="NWOgebied">
						<xsl:call-template name="getJson">
							<xsl:with-param name="varName">NWOgebied</xsl:with-param>
							<xsl:with-param name="value">
								<xsl:value-of select=".//column[@name='NWO gebied']"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>

					<xsl:variable name="jsonExtra">
						<xsl:value-of select="concat('{', $dossiernr, ',', $NWOgebied, '}')"/>
					</xsl:variable>
					<ROW table="projects">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$projectId"/>
						</FIELD>
						<FIELD name="id">
							<xsl:value-of select="$projectId"/>
						</FIELD>
						<FIELD name="code">
							<xsl:value-of select=".//column[@name='ProjectID']"/>
						</FIELD>
						<FIELD name="title">
							<xsl:value-of select=".//column[@name='Proj titel']"/>
						</FIELD>
						<FIELD name="startdate" type="date" format="dd/MM/yyyy">
							<xsl:value-of select="$startDate"/>
						</FIELD>
						<FIELD name="enddate" type="date" format="dd/MM/yyyy">
							<xsl:value-of select="$endDate"/>
						</FIELD>
						<FIELD name="collectedfrom">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
						<FIELD name="provenanceactionclass">sysimport:crosswalk:entityregistry</FIELD>
						<FIELD name="optional1">
							<xsl:value-of select=".//column[@name='Dossiernr']"/>
						</FIELD>
						<FIELD name="optional2">
							<xsl:value-of select=".//column[@name='NWO gebied']"/>
						</FIELD>
						<FIELD name="jsonextrainfo">
							<xsl:value-of select="$jsonExtra"/>
						</FIELD>
					</ROW>

					<xsl:variable name="funderId" select="concat($prefix, '::NWO')"/>
					<ROW table="project_fundingpath">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="concat($funderId, '@@', $projectId)"/>
						</FIELD>
						<FIELD name="funding">
							<xsl:value-of select="$funderId"/>
						</FIELD>
						<FIELD name="project">
							<xsl:value-of select="$projectId"/>
						</FIELD>
						<FIELD name="startdate" type="date" format="dd/MM/yyyy">
							<xsl:value-of select="$startDate"/>
						</FIELD>
						<FIELD name="enddate" type="date" format="dd/MM/yyyy">
							<xsl:value-of select="$endDate"/>
						</FIELD>
					</ROW>

				</ROWS>
			</metadata>
		</record>
	</xsl:template>

</xsl:stylesheet>
