<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" exclude-result-prefixes="fn">

    <xsl:param  name="namespacePrefix"/>
    <xsl:variable name="funderID" select="concat($namespacePrefix, '::CONICYT')"/>

    <xsl:template match="/">
        <fundingtree>
            <funder>
                <id>
                    <xsl:value-of select="$funderID"/>
                </id>
                <shortname>CONICYT</shortname>
                <name>Comisión Nacional de Investigación Científica y Tecnológica</name>
                <jurisdiction>CL</jurisdiction>
            </funder>
            <funding_level_1>
                <id>
                    <xsl:value-of select="concat($funderID, '::', .//column[@name='FUNDER STREAM LEVEL I'],'::',.//column[@name='FUNDER STREAM LEVEL II'])"/>
                </id>
                <description>
                    <xsl:value-of select="string('Fondecyt stream')"/>
                </description>
                <name>
                    <xsl:value-of select="string('FONDECYT Stream')"/>
                </name>
                <class>conicyt:fondecytfundings</class>
                <parent>
                    <funding_level_0>
                        <id>
                            <xsl:value-of select="concat($funderID, '::',.//column[@name='FUNDER STREAM LEVEL I'])"/>
                        </id>
                        <name>FONDECYT</name>
                        <description>Fondecyt fundings</description>
                        <parent/>
                        <class>conicyt:fondecytfundings</class>
                    </funding_level_0>
                </parent>
            </funding_level_1>

        </fundingtree>
    </xsl:template>
</xsl:stylesheet>
