/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.claims;

import eu.dnetlib.enabling.database.DataSourceFactory;
import eu.dnetlib.enabling.database.utils.JdbcTemplateFactory;
import eu.dnetlib.msro.openaireplus.workflows.nodes.claims.Claim;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ClaimDatabaseUtils {
    @Autowired
    private JdbcTemplateFactory claimsJdbcTemplateFactory;
    @Autowired
    private DataSourceFactory claimsDataSourceFactory;
    @Value(value="${dnet.openaire.claims.db.name}")
    private String dbName;

    public List<Claim> query(String sqlQuery) {
        this.claimsJdbcTemplateFactory.setDataSourceFactory(this.claimsDataSourceFactory);
        return this.claimsJdbcTemplateFactory.createJdbcTemplate(this.dbName).query(sqlQuery, (rs, rowNum) -> new Claim().setSemantics(rs.getString("semantics")).setSource(rs.getString("source_id")).setSourceType(rs.getString("source_type")).setTarget(rs.getString("target_id")).setTargetType(rs.getString("target_type")));
    }

    public int count(String sqlCountQuery) {
        this.claimsJdbcTemplateFactory.setDataSourceFactory(this.claimsDataSourceFactory);
        return (Integer)this.claimsJdbcTemplateFactory.createJdbcTemplate(this.dbName).queryForObject(sqlCountQuery, Integer.class);
    }
}

