SELECT
	dor.datasource                                                          AS datasource,
	dor.organization                                                        AS organization,
	dor.startdate                                                           AS startdate,
	dor.enddate                                                             AS enddate,
	dor.inferred                                                            AS inferred,
	dor.deletedbyinference                                                  AS deletedbyinference,
	dor.trust                                                               AS trust,
	dor.inferenceprovenance                                                 AS inferenceprovenance,

	doc.code || '@@@' || doc.name || '@@@' || dos.code || '@@@' || dos.name AS semantics,
	pac.code || '@@@' || pac.name || '@@@' || pas.code || '@@@' || pas.name AS provenanceaction

FROM datasource_organization dor

	LEFT OUTER JOIN datasources d ON (dor.datasource = d.id)

	LEFT OUTER JOIN class pac ON (pac.code = d.provenanceactionclass)
	LEFT OUTER JOIN scheme pas ON (pas.code = d.provenanceactionscheme)

	LEFT OUTER JOIN class doc ON (doc.code = dor.semanticclass)
	LEFT OUTER JOIN scheme dos ON (dos.code = dor.semanticscheme)

--  These clauses have been commented to allow the import of all the datasource on the index 
-- WHERE d.datasourceclass != 'entityregistry'
--	AND d.openairecompatibilityclass IS NOT null
--	AND d.openairecompatibilityclass != 'UNKNOWN'
--	AND d.openairecompatibilityclass != 'notCompatible'
