package eu.dnetlib.openaire.context;

import java.util.List;
import java.util.Optional;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.*;

@RestController
@CrossOrigin(origins = { "*" })
@ConditionalOnProperty(value = "openaire.exporter.enable.context", havingValue = "true")
@io.swagger.annotations.Api(tags = "OpenAIRE Context API", description = "the OpenAIRE Context API")
public class ContextApiController {

	@Autowired
	private ContextApiCore contextApiCore;

	@RequestMapping(value = "/contexts", produces = { "application/json" }, method = RequestMethod.GET)
	@ApiOperation(
			value = "list brief information about all the context profiles",
			notes = "list brief information about all the context profiles.",
			tags = { },
			response = ContextSummary[].class)
	@ApiResponses(value = {
			@ApiResponse(code = 200, message = "OK", response = ContextSummary[].class),
			@ApiResponse(code = 500, message = "unexpected error", response = ContextException.class) })
	public List<ContextSummary> listContexts(@RequestParam(required = false, defaultValue = "") List<String> type) throws ContextException {
		return contextApiCore.listContexts(type);
	}

	@RequestMapping(value = "/context/{contextId}", produces = { "application/json" }, method = RequestMethod.GET)
	@ApiOperation(
			value = "list the categories defined within a context",
			notes = "list the categories defined within a context",
			tags = { },
			response = CategorySummary[].class)
	@ApiResponses(value = {
			@ApiResponse(code = 200, message = "OK", response = CategorySummary[].class),
			@ApiResponse(code = 500, message = "unexpected error", response = ContextException.class) })
	public List<CategorySummary> listCategories(
			@PathVariable final String contextId,
			@RequestParam(required = false, defaultValue = "false") final Boolean all) throws ContextException {

		Boolean allFilter = Optional.ofNullable(all).orElse(false);
		return contextApiCore.listCategories(contextId, allFilter);
	}

	@RequestMapping(value = "/context/category/{categoryId}", produces = { "application/json" }, method = RequestMethod.GET)
	@ApiOperation(
			value = "list the concepts defined within a category",
			notes = "list the concepts defined within a category",
			tags = { },
			response = ConceptSummary[].class)
	@ApiResponses(value = {
			@ApiResponse(code = 200, message = "OK", response = ConceptSummary[].class),
			@ApiResponse(code = 500, message = "unexpected error", response = ContextException.class) })
	public List<ConceptSummary> listConcepts(
			@PathVariable final String categoryId,
			@RequestParam(required = false, defaultValue = "false") final Boolean all) throws ContextException {

		Boolean allFilter = Optional.ofNullable(all).orElse(false);
		return contextApiCore.listConcepts(categoryId, allFilter);
	}

	@RequestMapping(value = "/context/category/concept/{conceptId}", produces = { "application/json" }, method = RequestMethod.GET)
	@ApiOperation(
			value = "list the concepts defined within a category",
			notes = "list the concepts defined within a category",
			tags = { },
			response = ConceptSummary[].class)
	@ApiResponses(value = {
			@ApiResponse(code = 200, message = "OK", response = ConceptSummary[].class),
			@ApiResponse(code = 500, message = "unexpected error", response = ContextException.class) })
	public List<ConceptSummary> listSubConcepts(
			@PathVariable final String conceptId,
			@RequestParam(required = false, defaultValue = "false") final Boolean all) throws ContextException {

		Boolean allFilter = Optional.ofNullable(all).orElse(false);
		return contextApiCore.listSubConcepts(conceptId, allFilter);
	}

}
