package eu.dnetlib.openaire.dsm.domain;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.Set;

@JsonAutoDetect
@ApiModel(value = "Datasource model", description = "provides information about the datasource")
public class DatasourceSnippet {

    @NotBlank
    @ApiModelProperty(position = 0)
    private String id;

    @NotBlank
    @Length(max = 300)
    @ApiModelProperty(position = 2)
    private String officialname;

    @NotBlank
    @Length(max = 300)
    @ApiModelProperty(position = 3)
    private String englishname;

    @ApiModelProperty(position = 4)
    private String websiteurl;

    @Email
    @ApiModelProperty(position = 5)
    private String registeredby;

    @ApiModelProperty(position = 6)
    private Date registrationdate;

    @ApiModelProperty(position = 7)
    private String typology;

    @ApiModelProperty(position = 8)
    private Set<OrganizationDetails> organizations;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOfficialname() {
        return officialname;
    }

    public void setOfficialname(String officialname) {
        this.officialname = officialname;
    }

    public String getEnglishname() {
        return englishname;
    }

    public void setEnglishname(String englishname) {
        this.englishname = englishname;
    }

    public String getWebsiteurl() {
        return websiteurl;
    }

    public void setWebsiteurl(String websiteurl) {
        this.websiteurl = websiteurl;
    }

    public String getRegisteredby() {
        return registeredby;
    }

    public void setRegisteredby(String registeredby) {
        this.registeredby = registeredby;
    }

    public Date getRegistrationdate() {
        return registrationdate;
    }

    public void setRegistrationdate(Date registrationdate) {
        this.registrationdate = registrationdate;
    }

    public String getTypology() {
        return typology;
    }

    public void setTypology(String typology) {
        this.typology = typology;
    }

    public Set<OrganizationDetails> getOrganizations() {
        return organizations;
    }

    public void setOrganizations(Set<OrganizationDetails> organizations) {
        this.organizations = organizations;
    }

}
