package eu.dnetlib.openaire.community;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

public class CommunityOpenAIRECommunities {

    @NotNull
    @ApiModelProperty(value = "the zenodo community identifier", required = true)
    private String zenodoid;

    @NotNull
    @ApiModelProperty(value = "identifies this zenodo community within the context it belongs to", required = true)
    private List<String> openAirecommunitylist;

    public CommunityOpenAIRECommunities() {
        this.zenodoid = "";
        openAirecommunitylist=new ArrayList<>();
    }

    public List<String> getOpenAirecommunitylist() {
        return openAirecommunitylist;
    }

    public CommunityOpenAIRECommunities setOpenAirecommunitylist(List<String> openAirecommunitylist) {
        this.openAirecommunitylist = openAirecommunitylist;
        return this;
    }

    public String getZenodoid() {
        return zenodoid;
    }

    public CommunityOpenAIRECommunities setZenodoid(String zenodoid) {
        this.zenodoid = zenodoid;
        return this;
    }



}
