SELECT
	a.id                                                AS "id",
	a.protocol                                          AS "protocol",
	a.baseurl                                           AS "baseUrl",
	a.datasource                                        AS "datasource",
	a.contentdescription                                AS "contentdescription",
	a.active                                            AS "active",
	a.removable                                         AS "removable",
	a.typology                                          AS "typology",
	coalesce(a.compatibility_override, a.compatibility) AS "compatibility",
	a.compatibility_override IS NOT null                AS "isCompatibilityOverrided",
	a.metadata_identifier_path                          AS "metadataIdentifierPath",
	a.last_collection_total                             AS "lastCollectionTotal",
	a.last_collection_date                              AS "lastCollectionDate",
	a.last_collection_mdid                              AS "lastCollectionMdid",
	a.last_aggregation_total                            AS "lastAggregationTotal",
	a.last_aggregation_date                             AS "lastAggregationDate",
	a.last_aggregation_mdid                             AS "lastAggregationMdid",
	a.last_download_total                               AS "lastDownloadTotal",
	a.last_download_date                                AS "lastDownloadDate",
	a.last_download_objid                               AS "lastDownloadObjid",
	a.last_validation_job                               AS "lastValidationJob",
	array_agg(p.param || '=' || p.value)                AS "params"
FROM 
	dsm_api a
	LEFT OUTER JOIN dsm_apiparams p on (a.id = p.api)
WHERE
	a.datasource = :dsId
GROUP BY
	a.id,
	a.protocol,
	a.baseurl,
	a.datasource,
	a.contentdescription,
	a.active,
	a.removable,
	a.typology,
	a.compatibility_override,
	a.compatibility,
	a.metadata_identifier_path,
	a.last_collection_total,
	a.last_collection_date,
	a.last_collection_mdid,
	a.last_aggregation_total,
	a.last_aggregation_date,
	a.last_aggregation_mdid,
	a.last_download_total,
	a.last_download_date,
	a.last_download_objid,
	a.last_validation_job
