/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.oai.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.oai.utils.OAIParameterNames;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SetCurrentOAIDBJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(SetCurrentOAIDBJobNode.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String oaiDbName;
    private String xpathToCurrentDB = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']//CONFIGURATION/CURRENTDB";

    protected String execute(NodeToken token) throws Exception {
        String dbToSet = this.getTheOAIDBName(token);
        log.fatal((Object)("Setting OAI Publisher to use db " + dbToSet));
        String xUpdate = "update value " + this.xpathToCurrentDB + " with '" + dbToSet + "'";
        ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).executeXUpdate(xUpdate);
        return Arc.DEFAULT_ARC;
    }

    protected String getTheOAIDBName(NodeToken token) {
        return StringUtils.isNotBlank((String)this.oaiDbName) ? this.oaiDbName : token.getEnv().getAttribute(OAIParameterNames.OAI_DB);
    }

    public String getOaiDbName() {
        return this.oaiDbName;
    }

    public void setOaiDbName(String oaiDbName) {
        this.oaiDbName = oaiDbName;
    }

    public String getXpathToCurrentDB() {
        return this.xpathToCurrentDB;
    }

    public void setXpathToCurrentDB(String xpathToCurrentDB) {
        this.xpathToCurrentDB = xpathToCurrentDB;
    }
}

