/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.oai.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.oai.utils.OAIParameterNames;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrepareOaiDataJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareOaiDataJobNode.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String oaiDbName;
    private String oaiFormat;
    private String oaiLayout;
    private String oaiInterpretation;
    private String oaiSource;
    private boolean skipDuplicates = false;
    private String duplicateXPath;

    protected String execute(NodeToken token) throws Exception {
        log.info((Object)"start preparing job");
        token.getEnv().setAttribute(OAIParameterNames.OAI_ACTION_DATE, DateUtils.now_ISO8601());
        this.setIfNotBlank(OAIParameterNames.OAI_DB, this.oaiDbName, token);
        this.setIfNotBlank(OAIParameterNames.OAI_FORMAT_NAME, this.oaiFormat, token);
        this.setIfNotBlank(OAIParameterNames.OAI_FORMAT_LAYOUT, this.oaiLayout, token);
        this.setIfNotBlank(OAIParameterNames.OAI_FORMAT_INTERPRETATION, this.oaiInterpretation, token);
        this.setIfNotBlank(OAIParameterNames.OAI_COLLECTON, this.oaiFormat + "-" + this.oaiLayout + "-" + this.oaiInterpretation, token);
        String configurationProfile = this.getConfigurationProfile();
        this.setIfNotBlank(OAIParameterNames.OAI_CONFIGURATION_PROFILE, configurationProfile, token);
        token.getEnv().setAttribute(OAIParameterNames.OAI_SKIP_DUPLICATES, String.valueOf(this.skipDuplicates));
        if (this.skipDuplicates) {
            token.getEnv().setAttribute(OAIParameterNames.OAI_DUPLICATE_XPATH, this.duplicateXPath);
        }
        return Arc.DEFAULT_ARC;
    }

    private void setIfNotBlank(String attrName, String attrValue, NodeToken token) {
        if (StringUtils.isNotBlank((String)attrValue)) {
            token.getEnv().setAttribute(attrName, attrValue);
        }
    }

    private String getConfigurationProfile() throws MSROException {
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']");
        }
        catch (Exception e) {
            throw new MSROException("Cannot find OAI configuration profile", (Throwable)e);
        }
    }

    public String getOaiDbName() {
        return this.oaiDbName;
    }

    public void setOaiDbName(String oaiDbName) {
        this.oaiDbName = oaiDbName;
    }

    public String getOaiFormat() {
        return this.oaiFormat;
    }

    public void setOaiFormat(String oaiFormat) {
        this.oaiFormat = oaiFormat;
    }

    public String getOaiLayout() {
        return this.oaiLayout;
    }

    public void setOaiLayout(String oaiLayout) {
        this.oaiLayout = oaiLayout;
    }

    public String getOaiInterpretation() {
        return this.oaiInterpretation;
    }

    public void setOaiInterpretation(String oaiInterpretation) {
        this.oaiInterpretation = oaiInterpretation;
    }

    public String getOaiSource() {
        return this.oaiSource;
    }

    public void setOaiSource(String oaiSource) {
        this.oaiSource = oaiSource;
    }

    public boolean isSkipDuplicates() {
        return this.skipDuplicates;
    }

    public void setSkipDuplicates(boolean skipDuplicates) {
        this.skipDuplicates = skipDuplicates;
    }

    public String getDuplicateXPath() {
        return this.duplicateXPath;
    }

    public void setDuplicateXPath(String duplicateXPath) {
        this.duplicateXPath = duplicateXPath;
    }
}

