/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.sarasvati.icons;

import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.visual.common.NodeDrawConfig;
import com.googlecode.sarasvati.visual.util.FontUtil;
import eu.dnetlib.functionality.modular.ui.workflows.sarasvati.icons.AbstractIcon;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessJobIcon
extends AbstractIcon {
    private NodeToken token;
    private Color progressBarColor = Color.decode("#205fbc");
    private Color inaccurateProgressBarColor = Color.DARK_GRAY;
    private Color progressBarBGColor = Color.LIGHT_GRAY;
    private ProgressProvider progressProvider;
    private static final Log log = LogFactory.getLog(ProcessJobIcon.class);

    public ProcessJobIcon(Node node, NodeToken token, ProgressProvider progressProvider) {
        super(node);
        this.token = token;
        this.progressProvider = progressProvider;
        this.setColor(NodeDrawConfig.getColor((NodeToken)token));
        if (token != null && token.getEnv() != null && "true".equals(token.getEnv().getAttribute("system:hasFailed"))) {
            this.setFailed(true);
            this.setColor(Color.RED);
        }
        if (this.isJoin()) {
            this.setDashes(new float[]{8.0f, 4.0f});
        }
        this.setTerminal(node.getGraph().getOutputArcs(node).size() == 0);
        this.redrawImage();
    }

    public void redrawImage(Graphics2D gfx) {
        super.resetGfx(gfx);
        gfx.fillRoundRect(0, 0, 99, HEIGHT - 1, 10, 10);
        gfx.setColor(NodeDrawConfig.NODE_BORDER);
        BasicStroke stroke = new BasicStroke(2.0f, 2, 0, 10.0f, this.getDashes(), 0.0f);
        gfx.setStroke(stroke);
        gfx.drawRoundRect(0, 0, 99, HEIGHT - 1, 10, 10);
        gfx.setColor(Color.white);
        int padding = 6;
        int startX = 6;
        int maxWidth = this.getIconWidth() - 12;
        FontUtil.setSizedFont((Graphics)gfx, (String)this.getLabel(), (float)10.0f, (int)maxWidth);
        int strWidth = (int)Math.ceil(gfx.getFontMetrics().getStringBounds(this.getLabel(), gfx).getWidth());
        int strHeight = gfx.getFontMetrics().getAscent();
        int left = 6 + (maxWidth - strWidth >> 1);
        int top = this.getIconHeight() + strHeight >> 1;
        gfx.drawString(this.getLabel(), left, top);
        if (this.progressProvider != null && this.token != null && !this.token.isComplete()) {
            this.drawProgressBar(gfx);
        }
        super.resetGfx(gfx);
    }

    private void drawProgressBar(Graphics2D gfx) {
        try {
            int total = this.progressProvider.getTotalValue();
            int current = this.progressProvider.getCurrentValue();
            if (this.progressProvider.isInaccurate() || current > total) {
                gfx.setColor(this.inaccurateProgressBarColor);
                String text = Integer.toString(current);
                int strWidth = (int)Math.ceil(gfx.getFontMetrics().getStringBounds(text, gfx).getWidth());
                gfx.drawString(text, this.getIconWidth() - strWidth - 7, this.getIconHeight() - 3);
            } else {
                int x = 6;
                int y = this.getIconHeight() - 6;
                int widthTot = this.getIconWidth() - x - x;
                int height = 2;
                gfx.setColor(this.progressBarBGColor);
                gfx.fillRect(x, y, widthTot, height);
                gfx.setColor(this.progressBarColor);
                int widthCurr = 0;
                if (total > 0) {
                    widthCurr = Math.round(widthTot * current / total);
                }
                gfx.fillRect(x, y, widthCurr, height);
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error obtainig provider info", e);
            gfx.setColor(this.inaccurateProgressBarColor);
            int strWidth = (int)Math.ceil(gfx.getFontMetrics().getStringBounds("?", gfx).getWidth());
            gfx.drawString("?", this.getIconWidth() - strWidth - 7, this.getIconHeight() - 3);
        }
    }

    public NodeToken getToken() {
        return this.token;
    }

    public void setToken(NodeToken token) {
        this.token = token;
    }

    public Color getProgressBarColor() {
        return this.progressBarColor;
    }

    public void setProgressBarColor(Color progressBarColor) {
        this.progressBarColor = progressBarColor;
    }

    public Color getProgressBarBGColor() {
        return this.progressBarBGColor;
    }

    public void setProgressBarBGColor(Color progressBarBGColor) {
        this.progressBarBGColor = progressBarBGColor;
    }

    public Color getInaccurateProgressBarColor() {
        return this.inaccurateProgressBarColor;
    }

    public void setInaccurateProgressBarColor(Color inaccurateProgressBarColor) {
        this.inaccurateProgressBarColor = inaccurateProgressBarColor;
    }

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    public void setProgressProvider(ProgressProvider progressProvider) {
        this.progressProvider = progressProvider;
    }
}

