/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.objects.sections;

import com.google.common.collect.Sets;
import eu.dnetlib.functionality.modular.ui.workflows.objects.MetaWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISLookupClient;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;

public class WorkflowSectionGrouper {
    private Set<String> cache = Sets.newHashSet();
    private long cacheDate = 0L;
    private static final long CACHE_DURATION = 600000L;
    @Resource
    private ISLookupClient isLookupClient;

    public List<MetaWorkflowDescriptor> listMetaWorflowsForDatasource(String dsId) {
        return this.isLookupClient.listMetaWorflowsForDatasource(dsId);
    }

    public List<MetaWorkflowDescriptor> listMetaWorflowsForSection(String name) {
        return this.isLookupClient.listMetaWorflowsForSection(name);
    }

    public String getDatasourceName(String dsId) {
        return this.isLookupClient.getDatasourceName(dsId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllSectionNames() {
        Set<String> set = this.cache;
        synchronized (set) {
            if (this.cache.isEmpty() || DateUtils.now() - this.cacheDate > 600000L) {
                this.cache.clear();
                this.cache.addAll(this.isLookupClient.listSimpleWorflowSections());
                this.cacheDate = DateUtils.now();
            }
        }
        HashSet res = Sets.newHashSet(this.cache);
        res.remove("dataproviders");
        return res;
    }
}

