/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.objects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.googlecode.sarasvati.NodeToken;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class NodeTokenInfo {
    private String name;
    private long start;
    private long end;
    private List<EnvParam> params;

    public NodeTokenInfo(String name) {
        this.name = name;
        this.start = 0L;
        this.end = 0L;
        this.params = Lists.newArrayList();
    }

    public NodeTokenInfo(NodeToken token) {
        Date start = token.getCreateDate();
        Date end = token.getCompleteDate();
        this.name = token.getNode().getName();
        this.start = start == null ? 0L : start.getTime();
        this.end = end == null ? 0L : end.getTime();
        HashMap map = Maps.newHashMap();
        for (String name : token.getFullEnv().getAttributeNames()) {
            map.put(name, new EnvParam(name, token.getFullEnv().getAttribute(name)));
        }
        for (String name : token.getEnv().getAttributeNames()) {
            map.put(name, new EnvParam(name, token.getEnv().getAttribute(name)));
        }
        this.params = Lists.newArrayList(map.values());
        Collections.sort(this.params, new Comparator<EnvParam>(){

            @Override
            public int compare(EnvParam o1, EnvParam o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public List<EnvParam> getParams() {
        return this.params;
    }

    public class EnvParam {
        private String name;
        private String value;

        public EnvParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

