package eu.dnetlib.functionality.modular.ui.workflows.objects;

import java.util.Date;

import com.googlecode.sarasvati.GraphProcess;

import eu.dnetlib.msro.workflows.util.ProcessUtils;

public class ProcessListEntry {

	private String procId;
	private String wfId;
	private String name;
	private String family;
	private String status;
	private long date;
	private String repo;
	private String repoId;
	private String apiId;

	public ProcessListEntry() {}

	public ProcessListEntry(final String procId, final String wfId, final String name, final String family, final String status, final long date,
			final String repo, final String repoId, final String apiId) {
		this.procId = procId;
		this.wfId = wfId;
		this.name = name;
		this.family = family;
		this.status = status;
		this.date = date;
		this.repo = repo;
		this.repoId = repoId;
		this.apiId = apiId;
	}

	public ProcessListEntry(final String procId, final String wfId, final String name, final String family, final String status, final Date date,
			final String repo, final String repoId, final String apiId) {
		this(procId, wfId, name, family, status, dateToLong(date), repo, repoId, apiId);
	}

	public ProcessListEntry(final String procId, final GraphProcess process) {
		this(procId,
				ProcessUtils.calculateWfId(process),
				ProcessUtils.calculateName(process),
				ProcessUtils.calculateFamily(process),
				ProcessUtils.calculateStatus(process),
				ProcessUtils.calculateLastActivityDate(process),
				ProcessUtils.calculateRepo(process),
				ProcessUtils.calculateRepoId(process),
				ProcessUtils.calculateApiId(process));
	}

	public String getProcId() {
		return procId;
	}

	public void setProcId(final String procId) {
		this.procId = procId;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(final String status) {
		this.status = status;
	}

	public String getFamily() {
		return family;
	}

	public String getWfId() {
		return wfId;
	}

	public void setWfId(final String wfId) {
		this.wfId = wfId;
	}

	public long getDate() {
		return date;
	}

	public void setDate(final long date) {
		this.date = date;
	}

	public void setFamily(final String family) {
		this.family = family;
	}

	public String getRepo() {
		return repo;
	}

	public void setRepo(final String repo) {
		this.repo = repo;
	}

	private static long dateToLong(final Date date) {
		return date == null ? Long.MAX_VALUE : date.getTime();
	}

	public String getRepoId() {
		return repoId;
	}

	public void setRepoId(final String repoId) {
		this.repoId = repoId;
	}

	public String getApiId() {
		return apiId;
	}

	public void setApiId(final String apiId) {
		this.apiId = apiId;
	}

}
