/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.oozie;

import eu.dnetlib.data.hadoop.AbstractHadoopClient;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oozie.client.OozieClient;

public class OozieClientFactory
extends AbstractHadoopClient {
    private static final String ENV_ATTRIBUTE_OOZIE_SERVICE_LOC = "oozie.service.loc";
    private static final Log log = LogFactory.getLog(OozieClientFactory.class);

    public OozieClient newInstance(ClusterName clusterName) throws HadoopServiceException {
        String oozieServiceLocation = this.configurationEnumerator.get(clusterName).get(ENV_ATTRIBUTE_OOZIE_SERVICE_LOC);
        log.info((Object)("init oozie client, cluster: " + clusterName.toString() + ", oozie server: " + oozieServiceLocation));
        this.setHadoopUser();
        try {
            return new OozieClient(oozieServiceLocation);
        }
        catch (Throwable e) {
            throw new HadoopServiceException("unable to initialize oozie client for cluster: " + clusterName.toString(), e);
        }
    }
}

