/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.hbase;

import eu.dnetlib.data.hadoop.hbase.HbaseTableFeeder;
import eu.dnetlib.data.transform.Column;
import eu.dnetlib.data.transform.Row;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseDeleteFeeder
extends HbaseTableFeeder {
    private static final Log log = LogFactory.getLog(HBaseDeleteFeeder.class);

    @Override
    protected void addOperation(List<Mutation> buffer, Row row) {
        Delete delete = new Delete(Bytes.toBytes((String)row.getKey()));
        delete.setWriteToWAL(true);
        for (Column col : row) {
            log.debug((Object)String.format("deleting K: '%s' CF:'%s' Q:'%s'", row.getKey(), row.getColumnFamily(), col.getName()));
            delete.deleteColumns(Bytes.toBytes((String)row.getColumnFamily()), Bytes.toBytes((String)((String)col.getName())));
        }
        buffer.add((Mutation)delete);
    }
}

