/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.action;

import eu.dnetlib.data.hadoop.action.AbstractHadoopAction;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.hbase.HbaseTableFeeder;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ImportEprHbaseAction
extends AbstractHadoopAction {
    private static final Log log = LogFactory.getLog(ImportEprHbaseAction.class);
    private HbaseTableFeeder hbaseTableFeeder;

    @Override
    public void executeAsync(BlackboardServerHandler handler, BlackboardJob job) throws HadoopServiceException {
        String epr = DnetXsltFunctions.decodeBase64((String)((String)job.getParameters().get("input_epr")));
        String xsl = DnetXsltFunctions.decodeBase64((String)((String)job.getParameters().get("xslt")));
        ClusterName clusterName = ClusterName.valueOf((String)((String)job.getParameters().get("cluster")));
        String table = (String)job.getParameters().get("table");
        boolean simulation = Boolean.valueOf((String)job.getParameters().get("simulation"));
        log.info((Object)("Starting import in table " + table));
        try {
            Integer count = this.getHbaseTableFeeder().feed(epr, xsl, clusterName, table, simulation);
            if (count != null) {
                log.info((Object)"Import completed successfully");
                job.getParameters().put("count", String.valueOf(count));
            }
            handler.done(job);
        }
        catch (Throwable e) {
            log.error((Object)"Import failed", e);
            throw new HadoopServiceException("Import failed", e);
        }
    }

    public HbaseTableFeeder getHbaseTableFeeder() {
        return this.hbaseTableFeeder;
    }

    @Required
    public void setHbaseTableFeeder(HbaseTableFeeder hbaseTableFeeder) {
        this.hbaseTableFeeder = hbaseTableFeeder;
    }
}

