/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop;

import com.google.common.collect.Iterables;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ISClient {
    private static final Log log = LogFactory.getLog(ISClient.class);
    @Resource
    private UniqueServiceLocator serviceLocator;

    public String getJobProfile(String jobName) throws ISLookUpException {
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("/RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'HadoopJobConfigurationDSResourceType' and .//HADOOP_JOB/@name='" + jobName + "']");
    }

    public String queryForServiceProperty(String key) throws ISLookUpException {
        return this.getServiceConfigValue("for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='HadoopServiceResourceType'] return $x//SERVICE_PROPERTIES/PROPERTY[./@ key='" + key + "']/@value/string()");
    }

    public void updateCountElement(String jobName, String element, String delta) {
        String xquery = "let $x := //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='HadoopJobConfigurationDSResourceType' and .//HADOOP_JOB/@name='" + jobName + "'], $tot := $x//STATUS/" + element + "/@value/number() " + delta + " return update replace $x//STATUS/" + element + " with <" + element + " value='{$tot}' />";
        this.executeXUpdate(xquery);
    }

    public void updateDate(String jobName) {
        log.info((Object)("increment last submission date for job: " + jobName));
        this.executeXUpdate("for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='HadoopJobConfigurationDSResourceType' and .//HADOOP_JOB/@name='" + jobName + "']  return update value $x//LAST_SUBMISSION_DATE/@value with '" + DateUtils.now_ISO8601() + "' ");
    }

    private String getServiceConfigValue(String xquery) throws ISLookUpException {
        log.debug((Object)("quering for service property: " + xquery));
        List urls = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery);
        if (urls == null || urls.size() != 1) {
            throw new IllegalStateException("unable to find unique service property, xquery: " + xquery);
        }
        return (String)Iterables.getOnlyElement((Iterable)urls);
    }

    private boolean executeXUpdate(String xupdate) {
        try {
            log.debug((Object)("running xupdate: " + xupdate));
            return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).executeXUpdate(xupdate);
        }
        catch (ISRegistryException e) {
            log.error((Object)("unable to run xupdate: " + xupdate), (Throwable)e);
            return false;
        }
    }
}

