/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.modular.gridFS;

import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectStoreFileUtility {
    private static final int KB_SIZE = 1024;
    private static final Log log = LogFactory.getLog(ObjectStoreFileUtility.class);

    public static ObjectStoreFile build(GridFSDBFile input, String baseURI, String objectStoreID) {
        DBObject metadata = input.getMetaData();
        String originalFile = (String)metadata.get("originalObject");
        ObjectStoreFile original = ObjectStoreFile.createObject((String)originalFile);
        ObjectStoreFile newFile = new ObjectStoreFile();
        newFile.setObjectID((String)metadata.get("id"));
        newFile.setAccessProtocol(Protocols.HTTP);
        newFile.setMimeType((String)metadata.get("mime"));
        newFile.setMd5Sum((String)input.get("md5"));
        newFile.setFileSizeKB(input.getLength() / 1024L);
        if (originalFile != null) {
            newFile.setMetadataRelatedID(original.getMetadataRelatedID());
            if (original.getDownloadedURL() == null || original.getDownloadedURL().length() == 0) {
                newFile.setDownloadedURL(original.getURI());
            } else {
                newFile.setDownloadedURL(original.getDownloadedURL());
            }
        }
        try {
            newFile.setURI(baseURI + "?objectStore=" + URLEncoder.encode(objectStoreID, "UTF-8") + "&objectId=" + URLEncoder.encode(newFile.getObjectID(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Error on Build objectStoreFile ", (Throwable)e);
        }
        return newFile;
    }

    public static UnaryFunction<String, GridFSDBFile> asJSON(final String baseURI, final String objectStoreID) {
        return new UnaryFunction<String, GridFSDBFile>(){

            public String evaluate(GridFSDBFile input) {
                return ObjectStoreFileUtility.build(input, baseURI, objectStoreID).toJSON();
            }
        };
    }
}

